"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackByComboBoxWrapper = exports.StackByComboBox = exports.KpiPanel = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _config = require("./config");
var _hooks = require("./hooks");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/common/components.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_WIDTH = 400;
const KpiPanel = exports.KpiPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  display: flex;
  flex-direction: column;
  position: relative;
  overflow-x: hidden;
  overflow-y: ${({
  $overflowY
}) => $overflowY !== null && $overflowY !== void 0 ? $overflowY : 'hidden'};
  @media only screen and (min-width: ${props => props.theme.eui.euiBreakpoints.m}) {
    ${({
  height,
  $toggleStatus
}) => $toggleStatus && `
      height: ${height != null ? height : _config.PANEL_HEIGHT}px;
  `}
  }
  ${({
  $toggleStatus
}) => $toggleStatus && `
    height: ${_config.MOBILE_PANEL_HEIGHT}px;
  `}
`;
const StackByComboBoxWrapper = exports.StackByComboBoxWrapper = _styledComponents.default.div`
  max-width: 400px;
  width: ${({
  width
}) => width}px;
`;
const StackByComboBox = exports.StackByComboBox = /*#__PURE__*/_react.default.forwardRef(({
  'aria-label': ariaLabel = i18n.STACK_BY_ARIA_LABEL,
  'data-test-subj': dataTestSubj,
  isDisabled = false,
  onSelect,
  prepend = i18n.STACK_BY_LABEL,
  selected,
  inputRef,
  width = DEFAULT_WIDTH,
  dropDownoptions,
  useLensCompatibleFields
}, ref) => {
  const onChange = (0, _react.useCallback)(options => {
    if (options && options.length && options[0].value) {
      onSelect(options[0].value);
    } else {
      onSelect('');
    }
  }, [onSelect]);
  const selectedOptions = (0, _react.useMemo)(() => {
    return [{
      label: selected,
      value: selected
    }];
  }, [selected]);
  const getExpensiveFields = (0, _hooks.useStackByFields)(useLensCompatibleFields);
  const options = (0, _react.useMemo)(() => dropDownoptions !== null && dropDownoptions !== void 0 ? dropDownoptions : getExpensiveFields(), [dropDownoptions, getExpensiveFields]);
  const singleSelection = (0, _react.useMemo)(() => {
    return {
      asPlainText: true
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(StackByComboBoxWrapper, {
    width: width,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": dataTestSubj,
    "aria-label": ariaLabel,
    inputRef: inputRef,
    isDisabled: isDisabled,
    placeholder: i18n.STACK_BY_PLACEHOLDER,
    prepend: prepend,
    ref: ref,
    singleSelection: singleSelection,
    isClearable: false,
    sortMatchesBy: "startsWith",
    options: options,
    selectedOptions: selectedOptions,
    compressed: true,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }));
});
StackByComboBox.displayName = 'StackByComboBox';