"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserUnauthenticatedEmptyPage = exports.USER_UNAUTHENTICATED_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _translations = require("./translations");
var _empty_page = require("../../../../common/components/empty_page");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/empty_pages/user_unauthenticated_empty_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const USER_UNAUTHENTICATED_MSG_BODY = _i18n.i18n.translate('xpack.securitySolution.alertsPage.userUnauthenticatedMsgBody', {
  defaultMessage: 'You do not have the required permissions for viewing the detection engine. For more help, contact your administrator.'
});
const USER_UNAUTHENTICATED_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertsPage.userUnauthenticatedTitle', {
  defaultMessage: 'Detection engine permissions required'
});
const USER_UNAUTHENTICATED_TEST_ID = exports.USER_UNAUTHENTICATED_TEST_ID = 'alerts-page-user-unauthenticated';

/**
 * EmptyPage component displayed on the alerts page when the user is unauthenticated.
 * It provides a link to the documentation for detections requirements
 */
const UserUnauthenticatedEmptyPage = exports.UserUnauthenticatedEmptyPage = /*#__PURE__*/_react.default.memo(() => {
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  const actions = (0, _react.useMemo)(() => ({
    detectionUnauthenticated: {
      icon: 'documents',
      label: _translations.GO_TO_DOCUMENTATION,
      url: `${docLinks.links.siem.detectionsReq}`,
      target: '_blank'
    }
  }), [docLinks]);
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: actions,
    message: USER_UNAUTHENTICATED_MSG_BODY,
    "data-test-subj": USER_UNAUTHENTICATED_TEST_ID,
    title: USER_UNAUTHENTICATED_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
});
UserUnauthenticatedEmptyPage.displayName = 'UserUnauthenticatedEmtpyPage';