"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _pick_timeline = require("../../../../../rule_creation/components/pick_timeline");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/forms/timeline_template_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formSchema = {
  timeline: {
    label: _translations.bulkApplyTimelineTemplate.TEMPLATE_SELECTOR_LABEL,
    helpText: _translations.bulkApplyTimelineTemplate.TEMPLATE_SELECTOR_HELP_TEXT
  }
};
const defaultFormData = {
  timeline: {
    id: null,
    title: _translations.bulkApplyTimelineTemplate.TEMPLATE_SELECTOR_DEFAULT_VALUE
  }
};
const TimelineTemplateFormComponent = props => {
  const {
    rulesCount,
    onClose,
    onConfirm
  } = props;
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: formSchema,
    defaultValue: defaultFormData
  });
  const handleSubmit = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const timelineId = data.timeline.id || '';
    const timelineTitle = timelineId ? data.timeline.title : '';
    onConfirm({
      type: _rule_management.BulkActionEditTypeEnum.set_timeline,
      value: {
        timeline_id: timelineId,
        timeline_title: timelineTitle
      }
    });
  }, [form, onConfirm]);
  const warningCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "bulkEditRulesTimelineTemplateWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, _translations.bulkApplyTimelineTemplate.warningCalloutMessage(rulesCount));
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    title: _translations.bulkApplyTimelineTemplate.FORM_TITLE,
    banner: warningCallout,
    onClose: onClose,
    onSubmit: handleSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "timeline",
    component: _pick_timeline.PickTimeline,
    componentProps: {
      idAria: 'bulkEditRulesTimelineTemplateSelector',
      dataTestSubj: 'bulkEditRulesTimelineTemplateSelector',
      placeholder: _translations.bulkApplyTimelineTemplate.TEMPLATE_SELECTOR_PLACEHOLDER
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }));
};
const TimelineTemplateForm = exports.TimelineTemplateForm = /*#__PURE__*/_react.default.memo(TimelineTemplateFormComponent);
TimelineTemplateForm.displayName = 'TimelineTemplateForm';