"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdEditForm = ThresholdEditForm;
var _react = _interopRequireDefault(require("react"));
var _field_final_side = require("../../../field_final_side");
var _threshold_adapter = require("./threshold_adapter");
var _utils = require("../../../../../../../../../common/detection_engine/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/threshold/threshold_edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ThresholdEditForm() {
  return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
    component: _threshold_adapter.ThresholdAdapter,
    ruleFieldFormSchema: schema,
    deserializer: deserializer,
    serializer: serializer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  });
}
function deserializer(defaultValue) {
  var _threshold$value, _threshold$cardinalit;
  const threshold = defaultValue.threshold;
  const deserializedThreshold = {
    field: (0, _utils.normalizeThresholdField)(threshold.field),
    value: `${(_threshold$value = threshold === null || threshold === void 0 ? void 0 : threshold.value) !== null && _threshold$value !== void 0 ? _threshold$value : 100}`
  };
  if ((_threshold$cardinalit = threshold.cardinality) !== null && _threshold$cardinalit !== void 0 && _threshold$cardinalit.length) {
    deserializedThreshold.cardinality = {
      field: [`${threshold.cardinality[0].field}`],
      value: `${threshold.cardinality[0].value}`
    };
  }
  return {
    threshold: deserializedThreshold
  };
}
function serializer(formData) {
  var _threshold$cardinalit2, _threshold$cardinalit3;
  const threshold = formData.threshold;
  const serializedThreshold = {
    field: threshold.field,
    value: Number.parseInt(threshold.value, 10)
  };
  if ((_threshold$cardinalit2 = threshold.cardinality) !== null && _threshold$cardinalit2 !== void 0 && (_threshold$cardinalit3 = _threshold$cardinalit2.field) !== null && _threshold$cardinalit3 !== void 0 && _threshold$cardinalit3.length) {
    serializedThreshold.cardinality = [{
      field: threshold.cardinality.field[0],
      value: Number.parseInt(threshold.cardinality.value, 10)
    }];
  }
  return {
    threshold: serializedThreshold
  };
}
const schema = {};