"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequiredFieldsEdit = RequiredFieldsEdit;
exports.requiredFieldsDeserializer = requiredFieldsDeserializer;
exports.requiredFieldsSchema = void 0;
exports.requiredFieldsSerializer = requiredFieldsSerializer;
var _react = _interopRequireDefault(require("react"));
var _schema = require("../../../../../../rule_creation_ui/components/step_define_rule/schema");
var _required_fields = require("../../../../../../rule_creation/components/required_fields");
var _use_default_index_pattern = require("../../../../../hooks/use_default_index_pattern");
var _utils = require("../utils");
var _form = require("../../../../../../rule_creation_ui/pages/form");
var _helpers = require("../../../../../../rule_creation_ui/pages/rule_creation/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/required_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const requiredFieldsSchema = exports.requiredFieldsSchema = {
  requiredFields: _schema.schema.requiredFields
};
function RequiredFieldsEdit({
  finalDiffableRule
}) {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const indexPatternParameters = (0, _utils.getUseRuleIndexPatternParameters)(finalDiffableRule, defaultIndexPattern);
  const {
    indexPattern,
    isIndexPatternLoading
  } = (0, _form.useRuleIndexPattern)(indexPatternParameters);
  return /*#__PURE__*/_react.default.createElement(_required_fields.RequiredFields, {
    path: "requiredFields",
    indexPatternFields: indexPattern.fields,
    isIndexPatternLoading: isIndexPatternLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
}
function requiredFieldsDeserializer(defaultValue) {
  return {
    requiredFields: defaultValue.required_fields
  };
}
function requiredFieldsSerializer(formData) {
  var _formData$requiredFie;
  const requiredFields = (_formData$requiredFie = formData.requiredFields) !== null && _formData$requiredFie !== void 0 ? _formData$requiredFie : [];
  return {
    required_fields: (0, _helpers.removeEmptyRequiredFields)(requiredFields)
  };
}