"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleCustomizationsDiff = exports.PREBUILT_RULE_CUSTOMIZATIONS_FLYOUT_ANCHOR = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _utils = require("../../../../../../common/api/detection_engine/model/rule_schema/utils");
var _use_fetch_prebuilt_rule_base_version_query = require("../../../api/hooks/prebuilt_rules/use_fetch_prebuilt_rule_base_version_query");
var _rule_customizations_flyout = require("./rule_customizations_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_customizations_diff/use_rule_customizations_diff.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PREBUILT_RULE_CUSTOMIZATIONS_FLYOUT_ANCHOR = exports.PREBUILT_RULE_CUSTOMIZATIONS_FLYOUT_ANCHOR = 'PrebuiltRuleCustomizationsPreview';
const useRuleCustomizationsDiff = ({
  rule
}) => {
  const [isFlyoutOpen, {
    off: closeFlyout,
    on: openFlyout
  }] = (0, _reactHooks.useBoolean)(false);
  const [isReverting, {
    off: setRevertingFalse,
    on: setRevertingTrue
  }] = (0, _reactHooks.useBoolean)(false);
  const enabled = (0, _react.useMemo)(() => rule != null && (0, _utils.isCustomizedPrebuiltRule)(rule), [rule]);
  const {
    data,
    isLoading,
    error
  } = (0, _use_fetch_prebuilt_rule_base_version_query.useFetchPrebuiltRuleBaseVersionQuery)({
    id: rule === null || rule === void 0 ? void 0 : rule.id,
    enabled
  });

  // Handle when we receive an error when the base_version doesn't exist
  const doesBaseVersionExist = (0, _react.useMemo)(() => !error && data != null, [data, error]);
  const openCustomizationsPreviewFlyout = (0, _react.useCallback)(() => {
    setRevertingFalse();
    openFlyout();
  }, [openFlyout, setRevertingFalse]);
  const openCustomizationsRevertFlyout = (0, _react.useCallback)(() => {
    setRevertingTrue();
    openFlyout();
  }, [openFlyout, setRevertingTrue]);
  const modifiedFields = (0, _react.useMemo)(() => {
    var _data$diff$fields;
    return new Set(Object.keys((_data$diff$fields = data === null || data === void 0 ? void 0 : data.diff.fields) !== null && _data$diff$fields !== void 0 ? _data$diff$fields : {}));
  }, [data === null || data === void 0 ? void 0 : data.diff.fields]);
  return {
    ruleCustomizationsFlyout: isFlyoutOpen && !isLoading && data != null && doesBaseVersionExist ? /*#__PURE__*/_react.default.createElement(_rule_customizations_flyout.RuleCustomizationsFlyout, {
      diff: data.diff,
      currentRule: data.current_version,
      baseRule: data.base_version,
      isReverting: isReverting,
      closeFlyout: closeFlyout,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }) : null,
    openCustomizationsPreviewFlyout,
    openCustomizationsRevertFlyout,
    doesBaseVersionExist,
    isLoading,
    modifiedFields
  };
};
exports.useRuleCustomizationsDiff = useRuleCustomizationsDiff;