"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManualRuleRunConfirmation = void 0;
var _use_schedule_bulk_action_confirmation = require("../../../common/components/schedule_bulk_action_modal/use_schedule_bulk_action_confirmation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that controls manual rule run confirmation modal window and its content
 */
const useManualRuleRunConfirmation = () => {
  const {
    isScheduleBulkActionConfirmationVisible,
    showScheduleBulkActionConfirmation,
    cancelScheduleBulkAction,
    confirmScheduleBulkAction
  } = (0, _use_schedule_bulk_action_confirmation.useScheduleBulkActionConfirmation)();
  return {
    isManualRuleRunConfirmationVisible: isScheduleBulkActionConfirmationVisible,
    showManualRuleRunConfirmation: showScheduleBulkActionConfirmation,
    cancelManualRuleRun: cancelScheduleBulkAction,
    confirmManualRuleRun: confirmScheduleBulkAction
  };
};
exports.useManualRuleRunConfirmation = useManualRuleRunConfirmation;