"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveAlertOsTypes = exports.prepareExceptionItemsForBulkClose = exports.lowercaseHashValues = exports.isAlertFromEndpointEvent = exports.getProcessCodeSignature = exports.getPrepopulatedRuleExceptionWithHighlightFields = exports.getPrepopulatedRansomwareException = exports.getPrepopulatedMemorySignatureException = exports.getPrepopulatedMemoryShellcodeException = exports.getPrepopulatedEndpointException = exports.getPrepopulatedBehaviorException = exports.getFormattedComments = exports.getFileCodeSignature = exports.getEntityCodeSignature = exports.getDllCodeSignature = exports.getCodeSignatureValue = exports.getAlertHighlightedFields = exports.formatOperatingSystems = exports.formatExceptionItemForUpdate = exports.filterHighlightedFields = exports.enrichSharedExceptions = exports.enrichRuleExceptions = exports.enrichNewExceptionItemsWithName = exports.enrichNewExceptionItemsWithExpireTime = exports.enrichNewExceptionItemsWithComments = exports.enrichExistingExceptionItemWithComments = exports.enrichExceptionItemsWithOS = exports.defaultEndpointExceptionItems = exports.buildRuleExceptionWithConditions = exports.buildGetAlertByIdQuery = exports.buildExceptionEntriesFromAlertFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _get_alert_summary_rows = require("../../../common/components/event_details/get_alert_summary_rows");
var i18n = _interopRequireWildcard(require("./translations"));
var _with_copy_to_clipboard = require("../../../common/lib/clipboard/with_copy_to_clipboard");
var _field_names = require("../../../../common/field_maps/field_names");
var _highlighted_fields_config = require("./highlighted_fields_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/utils/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Formats os value array to a displayable string
 */
const formatOperatingSystems = osTypes => {
  return osTypes.filter(os => ['linux', 'macos', 'windows'].includes(os)).map(os => {
    if (os === 'macos') {
      return 'macOS';
    }
    return (0, _lodash.capitalize)(os);
  }).join(', ');
};
exports.formatOperatingSystems = formatOperatingSystems;
const commentCss = (0, _react2.css)`
  white-space: pre-wrap;
`;

/**
 * Formats ExceptionItem.comments into EuiCommentList format
 *
 * @param comments ExceptionItem.comments
 */
const getFormattedComments = comments => comments.map(commentItem => ({
  username: commentItem.created_by,
  timestamp: (0, _moment.default)(commentItem.created_at).format('on MMM Do YYYY @ HH:mm:ss'),
  event: i18n.COMMENT_EVENT,
  timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: "l",
    name: commentItem.created_by.toUpperCase(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 21
    }
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: commentCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, commentItem.comment),
  actions: /*#__PURE__*/_react.default.createElement(_with_copy_to_clipboard.WithCopyToClipboard, {
    "data-test-subj": "copy-to-clipboard",
    text: commentItem.comment,
    titleSummary: i18n.ADD_TO_CLIPBOARD,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  })
}));
exports.getFormattedComments = getFormattedComments;
const formatExceptionItemForUpdate = exceptionItem => {
  /* eslint-disable @typescript-eslint/naming-convention */
  const {
    created_at,
    created_by,
    list_id,
    tie_breaker_id,
    updated_at,
    updated_by,
    /* eslint-enable @typescript-eslint/naming-convention */
    ...fieldsToUpdate
  } = exceptionItem;
  return {
    ...fieldsToUpdate
  };
};

/**
 * Maps "event." fields to "signal.original_event.". This is because when a rule is created
 * the "event" field is copied over to "original_event". When the user creates an exception,
 * they expect it to match against the original_event's fields, not the signal event's.
 * @param exceptionItems new or existing ExceptionItem[]
 */
exports.formatExceptionItemForUpdate = formatExceptionItemForUpdate;
const prepareExceptionItemsForBulkClose = exceptionItems => {
  return exceptionItems.map(item => {
    if (item.entries !== undefined) {
      const newEntries = item.entries.map(itemEntry => {
        const entry = (0, _lodash.omit)(itemEntry, 'id');
        return {
          ...entry,
          field: entry.field.startsWith('event.') ? entry.field.replace(/^event./, `${_field_names.ALERT_ORIGINAL_EVENT}.`) : entry.field
        };
      });
      return {
        ...item,
        entries: newEntries,
        comments: [] // Strips out unneeded comments attribute for bulk close as they are not needed and are throwing type errors
      };
    } else {
      return {
        ...item,
        comments: []
      };
    }
  });
};

/**
 * Adds new and existing comments to all new exceptionItems if not present already
 * @param exceptionItems new or existing ExceptionItem[]
 * @param comments new Comment
 */
exports.prepareExceptionItemsForBulkClose = prepareExceptionItemsForBulkClose;
const enrichNewExceptionItemsWithComments = (exceptionItems, comments) => {
  return exceptionItems.map(item => {
    return {
      ...item,
      comments
    };
  });
};

/**
 * Adds expireTime to all new exceptionItems if not present already
 * @param exceptionItems new or existing ExceptionItem[]
 * @param expireTime new expireTime
 */
exports.enrichNewExceptionItemsWithComments = enrichNewExceptionItemsWithComments;
const enrichNewExceptionItemsWithExpireTime = (exceptionItems, expireTime) => {
  const expireTimeDateString = expireTime !== undefined ? expireTime.toISOString() : undefined;
  return exceptionItems.map(item => {
    return {
      ...item,
      expire_time: expireTimeDateString
    };
  });
};
exports.enrichNewExceptionItemsWithExpireTime = enrichNewExceptionItemsWithExpireTime;
const buildGetAlertByIdQuery = id => ({
  query: {
    match: {
      _id: {
        query: id || ''
      }
    }
  }
});

/**
 * Adds new and existing comments to exceptionItem
 * @param exceptionItem existing ExceptionItem
 * @param comments array of comments that can include existing
 * and new comments
 */
exports.buildGetAlertByIdQuery = buildGetAlertByIdQuery;
const enrichExistingExceptionItemWithComments = (exceptionItem, comments) => {
  const formattedComments = comments.map(item => {
    if (_securitysolutionIoTsListTypes.comment.is(item)) {
      const {
        id,
        comment: existingComment
      } = item;
      return {
        id,
        comment: existingComment
      };
    } else {
      return {
        comment: item.comment
      };
    }
  });
  return {
    ...exceptionItem,
    comments: formattedComments
  };
};

/**
 * Adds provided osTypes to all exceptionItems if not present already
 * @param exceptionItems new or existing ExceptionItem[]
 * @param osTypes array of os values
 */
exports.enrichExistingExceptionItemWithComments = enrichExistingExceptionItemWithComments;
const enrichExceptionItemsWithOS = (exceptionItems, osTypes) => {
  return exceptionItems.map(item => {
    return {
      ...item,
      os_types: osTypes
    };
  });
};
exports.enrichExceptionItemsWithOS = enrichExceptionItemsWithOS;
const retrieveAlertOsTypes = alertData => {
  const osDefaults = ['windows', 'macos'];
  if (alertData != null) {
    var _alertData$agent, _alertData$host, _alertData$host$os, _alertData$host$os$na, _alertData$host2, _alertData$host2$os;
    const os = (alertData === null || alertData === void 0 ? void 0 : (_alertData$agent = alertData.agent) === null || _alertData$agent === void 0 ? void 0 : _alertData$agent.type) === 'endpoint' ? (_alertData$host = alertData.host) === null || _alertData$host === void 0 ? void 0 : (_alertData$host$os = _alertData$host.os) === null || _alertData$host$os === void 0 ? void 0 : (_alertData$host$os$na = _alertData$host$os.name) === null || _alertData$host$os$na === void 0 ? void 0 : _alertData$host$os$na.toLowerCase() : (_alertData$host2 = alertData.host) === null || _alertData$host2 === void 0 ? void 0 : (_alertData$host2$os = _alertData$host2.os) === null || _alertData$host2$os === void 0 ? void 0 : _alertData$host2$os.family;
    if (os != null) {
      return _securitysolutionIoTsListTypes.osType.is(os) ? [os] : osDefaults;
    }
  }
  return osDefaults;
};

/**
 * Returns given exceptionItems with all hash-related entries lowercased
 */
exports.retrieveAlertOsTypes = retrieveAlertOsTypes;
const lowercaseHashValues = exceptionItems => {
  return exceptionItems.map(item => {
    const newEntries = item.entries.map(itemEntry => {
      if (itemEntry.field.includes('.hash')) {
        if (itemEntry.type === 'match') {
          return {
            ...itemEntry,
            value: itemEntry.value.toLowerCase()
          };
        } else if (itemEntry.type === 'match_any') {
          return {
            ...itemEntry,
            value: itemEntry.value.map(val => val.toLowerCase())
          };
        }
      }
      return itemEntry;
    });
    return {
      ...item,
      entries: newEntries
    };
  });
};

/**
 * Generic function to get code signature entries from any entity
 */
exports.lowercaseHashValues = lowercaseHashValues;
const getEntityCodeSignature = (entity, fieldPrefix) => {
  var _entity$Ext, _entity$code_signatur;
  if (!entity) return undefined;

  // Check Ext.code_signature first
  if ((_entity$Ext = entity.Ext) !== null && _entity$Ext !== void 0 && _entity$Ext.code_signature) {
    return getCodeSignatureValue(entity.Ext.code_signature, `${fieldPrefix}.Ext.code_signature`);
  }

  // Then check direct code_signature
  if (((_entity$code_signatur = entity.code_signature) === null || _entity$code_signatur === void 0 ? void 0 : _entity$code_signatur.trusted) === true) {
    var _entity$code_signatur2, _entity$code_signatur3;
    return [{
      field: `${fieldPrefix}.code_signature.subject_name`,
      operator: 'included',
      type: 'match',
      value: (_entity$code_signatur2 = (_entity$code_signatur3 = entity.code_signature) === null || _entity$code_signatur3 === void 0 ? void 0 : _entity$code_signatur3.subject_name.toString()) !== null && _entity$code_signatur2 !== void 0 ? _entity$code_signatur2 : ''
    }, {
      field: `${fieldPrefix}.code_signature.trusted`,
      operator: 'included',
      type: 'match',
      value: entity.code_signature.trusted.toString()
    }];
  }
  return undefined;
};

/**
 * Returns an array of exception entries for either
 * `file.Ext.code_signature` or 'file.code_signature`
 * as long as the `trusted` field is `true`.
 */
exports.getEntityCodeSignature = getEntityCodeSignature;
const getFileCodeSignature = alertData => getEntityCodeSignature(alertData.file, 'file');

/**
 * Returns an array of exception entries for either
 * `process.Ext.code_signature` or 'process.code_signature`
 * as long as the `trusted` field is `true`.
 */
exports.getFileCodeSignature = getFileCodeSignature;
const getProcessCodeSignature = alertData => getEntityCodeSignature(alertData.process, 'process');

/**
 * Returns an array of exception entries for either
 * `dll.Ext.code_signature` or 'dll.code_signature`
 * as long as the `trusted` field is `true`.
 */
exports.getProcessCodeSignature = getProcessCodeSignature;
const getDllCodeSignature = alertData => getEntityCodeSignature(alertData.dll, 'dll');

/**
 * Pre 7.10 `Ext.code_signature` fields were mistakenly populated as
 * a single object with subject_name and trusted.
 */
exports.getDllCodeSignature = getDllCodeSignature;
const getCodeSignatureValue = (codeSignature, field) => {
  if (Array.isArray(codeSignature) && codeSignature.length > 0) {
    const codeSignatureEntries = [];
    const noDuplicates = new Map();
    return codeSignature.reduce((acc, signature) => {
      if ((signature === null || signature === void 0 ? void 0 : signature.trusted) === true && !noDuplicates.has(signature === null || signature === void 0 ? void 0 : signature.subject_name)) {
        var _signature$subject_na;
        noDuplicates.set(signature.subject_name, signature.trusted);
        acc.push({
          field,
          type: 'nested',
          entries: [{
            field: 'subject_name',
            operator: 'included',
            type: 'match',
            value: (_signature$subject_na = signature === null || signature === void 0 ? void 0 : signature.subject_name) !== null && _signature$subject_na !== void 0 ? _signature$subject_na : ''
          }, {
            field: 'trusted',
            operator: 'included',
            type: 'match',
            value: signature.trusted.toString()
          }]
        });
      }
      return acc;
    }, codeSignatureEntries);
  } else {
    const signature = !Array.isArray(codeSignature) ? codeSignature : undefined;
    if ((signature === null || signature === void 0 ? void 0 : signature.trusted) === true) {
      var _signature$subject_na2;
      return [{
        field,
        type: 'nested',
        entries: [{
          field: 'subject_name',
          operator: 'included',
          type: 'match',
          value: (_signature$subject_na2 = signature === null || signature === void 0 ? void 0 : signature.subject_name) !== null && _signature$subject_na2 !== void 0 ? _signature$subject_na2 : ''
        }, {
          field: 'trusted',
          operator: 'included',
          type: 'match',
          value: signature.trusted.toString()
        }]
      }];
    }
  }
};

/**
 * Takes an array of Entries and filter out the ones with empty values.
 * It will also filter out empty values for nested entries.
 */
exports.getCodeSignatureValue = getCodeSignatureValue;
function filterEmptyExceptionEntries(entries) {
  const finalEntries = [];
  for (const entry of entries) {
    var _entry$value;
    if ('entries' in entry && entry.entries !== undefined) {
      entry.entries = entry.entries.filter(el => 'value' in el && el.value !== undefined && el.value.length > 0);
      finalEntries.push(entry);
    } else if ('value' in entry && (entry === null || entry === void 0 ? void 0 : (_entry$value = entry.value) === null || _entry$value === void 0 ? void 0 : _entry$value.length) > 0) {
      finalEntries.push(entry);
    }
  }
  return finalEntries;
}

/**
 * Returns the default values from the alert data to autofill new endpoint exceptions
 */
const getPrepopulatedEndpointException = ({
  listId,
  name,
  eventCode,
  listNamespace = 'agnostic',
  alertEcsData
}) => {
  var _file$path, _file$hash$sha, _file$hash, _host$os;
  const {
    file,
    host
  } = alertEcsData;
  const fileCodeSignature = getFileCodeSignature(alertEcsData);
  const filePath = (_file$path = file === null || file === void 0 ? void 0 : file.path) !== null && _file$path !== void 0 ? _file$path : '';
  const sha256Hash = (_file$hash$sha = file === null || file === void 0 ? void 0 : (_file$hash = file.hash) === null || _file$hash === void 0 ? void 0 : _file$hash.sha256) !== null && _file$hash$sha !== void 0 ? _file$hash$sha : '';
  const isLinux = (host === null || host === void 0 ? void 0 : (_host$os = host.os) === null || _host$os === void 0 ? void 0 : _host$os.name) === 'Linux';
  const commonFields = [{
    field: isLinux ? 'file.path' : 'file.path.caseless',
    operator: 'included',
    type: 'match',
    value: filePath !== null && filePath !== void 0 ? filePath : ''
  }, {
    field: 'file.hash.sha256',
    operator: 'included',
    type: 'match',
    value: sha256Hash !== null && sha256Hash !== void 0 ? sha256Hash : ''
  }, {
    field: 'event.code',
    operator: 'included',
    type: 'match',
    value: eventCode !== null && eventCode !== void 0 ? eventCode : ''
  }];
  const entriesToAdd = () => {
    if (!isLinux && fileCodeSignature !== undefined) {
      return (0, _securitysolutionListUtils.addIdToEntries)(filterEmptyExceptionEntries(commonFields.concat(fileCodeSignature)));
    } else {
      return (0, _securitysolutionListUtils.addIdToEntries)(filterEmptyExceptionEntries(commonFields));
    }
  };
  return {
    ...(0, _securitysolutionListUtils.getNewExceptionItem)({
      listId,
      namespaceType: listNamespace,
      name
    }),
    entries: entriesToAdd()
  };
};

/**
 * Returns the default values from the alert data to autofill new endpoint exceptions
 */
exports.getPrepopulatedEndpointException = getPrepopulatedEndpointException;
const getPrepopulatedRansomwareException = ({
  listId,
  name,
  eventCode,
  listNamespace = 'agnostic',
  alertEcsData
}) => {
  var _process$hash$sha, _process$hash, _process$executable, _Ransomware$feature, _host$os2;
  const {
    process,
    Ransomware,
    host
  } = alertEcsData;
  const processCodeSignature = getProcessCodeSignature(alertEcsData);
  const sha256Hash = (_process$hash$sha = process === null || process === void 0 ? void 0 : (_process$hash = process.hash) === null || _process$hash === void 0 ? void 0 : _process$hash.sha256) !== null && _process$hash$sha !== void 0 ? _process$hash$sha : '';
  const executable = (_process$executable = process === null || process === void 0 ? void 0 : process.executable) !== null && _process$executable !== void 0 ? _process$executable : '';
  const ransomwareFeature = (_Ransomware$feature = Ransomware === null || Ransomware === void 0 ? void 0 : Ransomware.feature) !== null && _Ransomware$feature !== void 0 ? _Ransomware$feature : '';
  const isLinux = (host === null || host === void 0 ? void 0 : (_host$os2 = host.os) === null || _host$os2 === void 0 ? void 0 : _host$os2.name) === 'Linux';
  const commonFields = [{
    field: 'process.executable',
    operator: 'included',
    type: 'match',
    value: executable !== null && executable !== void 0 ? executable : ''
  }, {
    field: 'process.hash.sha256',
    operator: 'included',
    type: 'match',
    value: sha256Hash !== null && sha256Hash !== void 0 ? sha256Hash : ''
  }, {
    field: 'Ransomware.feature',
    operator: 'included',
    type: 'match',
    value: ransomwareFeature !== null && ransomwareFeature !== void 0 ? ransomwareFeature : ''
  }, {
    field: 'event.code',
    operator: 'included',
    type: 'match',
    value: eventCode !== null && eventCode !== void 0 ? eventCode : ''
  }];
  const entriesToAdd = () => {
    if (!isLinux && processCodeSignature !== undefined) {
      return (0, _securitysolutionListUtils.addIdToEntries)(filterEmptyExceptionEntries(commonFields.concat(processCodeSignature)));
    } else {
      return (0, _securitysolutionListUtils.addIdToEntries)(filterEmptyExceptionEntries(commonFields));
    }
  };
  return {
    ...(0, _securitysolutionListUtils.getNewExceptionItem)({
      listId,
      namespaceType: listNamespace,
      name
    }),
    entries: entriesToAdd()
  };
};
exports.getPrepopulatedRansomwareException = getPrepopulatedRansomwareException;
const getPrepopulatedMemorySignatureException = ({
  listId,
  name,
  eventCode,
  listNamespace = 'agnostic',
  alertEcsData
}) => {
  var _alertEcsData$Memory_, _alertEcsData$Memory_2, _process$executable2, _process$name, _process$hash$sha2, _process$hash2;
  const {
    process
  } = alertEcsData;
  const entries = filterEmptyExceptionEntries([{
    field: 'Memory_protection.feature',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$Memory_ = (_alertEcsData$Memory_2 = alertEcsData.Memory_protection) === null || _alertEcsData$Memory_2 === void 0 ? void 0 : _alertEcsData$Memory_2.feature) !== null && _alertEcsData$Memory_ !== void 0 ? _alertEcsData$Memory_ : ''
  }, {
    field: 'process.executable.caseless',
    operator: 'included',
    type: 'match',
    value: (_process$executable2 = process === null || process === void 0 ? void 0 : process.executable) !== null && _process$executable2 !== void 0 ? _process$executable2 : ''
  }, {
    field: 'process.name.caseless',
    operator: 'included',
    type: 'match',
    value: (_process$name = process === null || process === void 0 ? void 0 : process.name) !== null && _process$name !== void 0 ? _process$name : ''
  }, {
    field: 'process.hash.sha256',
    operator: 'included',
    type: 'match',
    value: (_process$hash$sha2 = process === null || process === void 0 ? void 0 : (_process$hash2 = process.hash) === null || _process$hash2 === void 0 ? void 0 : _process$hash2.sha256) !== null && _process$hash$sha2 !== void 0 ? _process$hash$sha2 : ''
  }]);
  return {
    ...(0, _securitysolutionListUtils.getNewExceptionItem)({
      listId,
      namespaceType: listNamespace,
      name
    }),
    entries: (0, _securitysolutionListUtils.addIdToEntries)(entries)
  };
};
exports.getPrepopulatedMemorySignatureException = getPrepopulatedMemorySignatureException;
const getPrepopulatedMemoryShellcodeException = ({
  listId,
  name,
  eventCode,
  listNamespace = 'agnostic',
  alertEcsData
}) => {
  var _alertEcsData$Memory_3, _alertEcsData$Memory_4, _String, _alertEcsData$Memory_5, _process$executable3, _process$name2, _process$Ext$token$in, _process$Ext, _process$Ext$token;
  const {
    process
  } = alertEcsData;
  const entries = filterEmptyExceptionEntries([{
    field: 'Memory_protection.feature',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$Memory_3 = (_alertEcsData$Memory_4 = alertEcsData.Memory_protection) === null || _alertEcsData$Memory_4 === void 0 ? void 0 : _alertEcsData$Memory_4.feature) !== null && _alertEcsData$Memory_3 !== void 0 ? _alertEcsData$Memory_3 : ''
  }, {
    field: 'Memory_protection.self_injection',
    operator: 'included',
    type: 'match',
    value: (_String = String((_alertEcsData$Memory_5 = alertEcsData.Memory_protection) === null || _alertEcsData$Memory_5 === void 0 ? void 0 : _alertEcsData$Memory_5.self_injection)) !== null && _String !== void 0 ? _String : ''
  }, {
    field: 'process.executable.caseless',
    operator: 'included',
    type: 'match',
    value: (_process$executable3 = process === null || process === void 0 ? void 0 : process.executable) !== null && _process$executable3 !== void 0 ? _process$executable3 : ''
  }, {
    field: 'process.name.caseless',
    operator: 'included',
    type: 'match',
    value: (_process$name2 = process === null || process === void 0 ? void 0 : process.name) !== null && _process$name2 !== void 0 ? _process$name2 : ''
  }, {
    field: 'process.Ext.token.integrity_level_name',
    operator: 'included',
    type: 'match',
    value: (_process$Ext$token$in = process === null || process === void 0 ? void 0 : (_process$Ext = process.Ext) === null || _process$Ext === void 0 ? void 0 : (_process$Ext$token = _process$Ext.token) === null || _process$Ext$token === void 0 ? void 0 : _process$Ext$token.integrity_level_name) !== null && _process$Ext$token$in !== void 0 ? _process$Ext$token$in : ''
  }]);
  return {
    ...(0, _securitysolutionListUtils.getNewExceptionItem)({
      listId,
      namespaceType: listNamespace,
      name
    }),
    entries: (0, _securitysolutionListUtils.addIdToEntries)(entries)
  };
};

/* eslint complexity: ["error", 21]*/
exports.getPrepopulatedMemoryShellcodeException = getPrepopulatedMemoryShellcodeException;
const getPrepopulatedBehaviorException = ({
  listId,
  name,
  eventCode,
  listNamespace = 'agnostic',
  alertEcsData
}) => {
  var _host$os3, _alertEcsData$rule$id, _alertEcsData$rule, _process$executable4, _process$command_line, _process$parent$execu, _process$parent, _alertEcsData$file$pa, _alertEcsData$file, _alertEcsData$file$na, _alertEcsData$file2, _alertEcsData$source$, _alertEcsData$source, _alertEcsData$destina, _alertEcsData$destina2, _alertEcsData$registr, _alertEcsData$registr2, _alertEcsData$registr3, _alertEcsData$registr4, _alertEcsData$registr5, _alertEcsData$registr6, _alertEcsData$registr7, _alertEcsData$dll$pat, _alertEcsData$dll, _alertEcsData$dll$pe$, _alertEcsData$dll2, _alertEcsData$dll2$pe, _alertEcsData$dns$que, _alertEcsData$dns, _alertEcsData$dns$que2, _alertEcsData$dns$que3, _alertEcsData$dns2, _alertEcsData$dns2$qu, _alertEcsData$user$id, _alertEcsData$user;
  const {
    process,
    host
  } = alertEcsData;
  const processCodeSignature = getProcessCodeSignature(alertEcsData);
  const dllCodeSignature = getDllCodeSignature(alertEcsData);
  const isLinux = (host === null || host === void 0 ? void 0 : (_host$os3 = host.os) === null || _host$os3 === void 0 ? void 0 : _host$os3.name) === 'Linux';
  const commonFields = [{
    field: 'rule.id',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$rule$id = (_alertEcsData$rule = alertEcsData.rule) === null || _alertEcsData$rule === void 0 ? void 0 : _alertEcsData$rule.id) !== null && _alertEcsData$rule$id !== void 0 ? _alertEcsData$rule$id : ''
  }, {
    field: 'process.executable.caseless',
    operator: 'included',
    type: 'match',
    value: (_process$executable4 = process === null || process === void 0 ? void 0 : process.executable) !== null && _process$executable4 !== void 0 ? _process$executable4 : ''
  }, {
    field: 'process.command_line',
    operator: 'included',
    type: 'match',
    value: (_process$command_line = process === null || process === void 0 ? void 0 : process.command_line) !== null && _process$command_line !== void 0 ? _process$command_line : ''
  }, {
    field: 'process.parent.executable',
    operator: 'included',
    type: 'match',
    value: (_process$parent$execu = process === null || process === void 0 ? void 0 : (_process$parent = process.parent) === null || _process$parent === void 0 ? void 0 : _process$parent.executable) !== null && _process$parent$execu !== void 0 ? _process$parent$execu : ''
  }, {
    field: 'file.path',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$file$pa = (_alertEcsData$file = alertEcsData.file) === null || _alertEcsData$file === void 0 ? void 0 : _alertEcsData$file.path) !== null && _alertEcsData$file$pa !== void 0 ? _alertEcsData$file$pa : ''
  }, {
    field: 'file.name',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$file$na = (_alertEcsData$file2 = alertEcsData.file) === null || _alertEcsData$file2 === void 0 ? void 0 : _alertEcsData$file2.name) !== null && _alertEcsData$file$na !== void 0 ? _alertEcsData$file$na : ''
  }, {
    field: 'source.ip',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$source$ = (_alertEcsData$source = alertEcsData.source) === null || _alertEcsData$source === void 0 ? void 0 : _alertEcsData$source.ip) !== null && _alertEcsData$source$ !== void 0 ? _alertEcsData$source$ : ''
  }, {
    field: 'destination.ip',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$destina = (_alertEcsData$destina2 = alertEcsData.destination) === null || _alertEcsData$destina2 === void 0 ? void 0 : _alertEcsData$destina2.ip) !== null && _alertEcsData$destina !== void 0 ? _alertEcsData$destina : ''
  }, {
    field: 'registry.path',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$registr = (_alertEcsData$registr2 = alertEcsData.registry) === null || _alertEcsData$registr2 === void 0 ? void 0 : _alertEcsData$registr2.path) !== null && _alertEcsData$registr !== void 0 ? _alertEcsData$registr : ''
  }, {
    field: 'registry.value',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$registr3 = (_alertEcsData$registr4 = alertEcsData.registry) === null || _alertEcsData$registr4 === void 0 ? void 0 : _alertEcsData$registr4.value) !== null && _alertEcsData$registr3 !== void 0 ? _alertEcsData$registr3 : ''
  }, {
    field: 'registry.data.strings',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$registr5 = (_alertEcsData$registr6 = alertEcsData.registry) === null || _alertEcsData$registr6 === void 0 ? void 0 : (_alertEcsData$registr7 = _alertEcsData$registr6.data) === null || _alertEcsData$registr7 === void 0 ? void 0 : _alertEcsData$registr7.strings) !== null && _alertEcsData$registr5 !== void 0 ? _alertEcsData$registr5 : ''
  }, {
    field: 'dll.path',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$dll$pat = (_alertEcsData$dll = alertEcsData.dll) === null || _alertEcsData$dll === void 0 ? void 0 : _alertEcsData$dll.path) !== null && _alertEcsData$dll$pat !== void 0 ? _alertEcsData$dll$pat : ''
  }, {
    field: 'dll.pe.original_file_name',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$dll$pe$ = (_alertEcsData$dll2 = alertEcsData.dll) === null || _alertEcsData$dll2 === void 0 ? void 0 : (_alertEcsData$dll2$pe = _alertEcsData$dll2.pe) === null || _alertEcsData$dll2$pe === void 0 ? void 0 : _alertEcsData$dll2$pe.original_file_name) !== null && _alertEcsData$dll$pe$ !== void 0 ? _alertEcsData$dll$pe$ : ''
  }, {
    field: 'dns.question.name',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$dns$que = (_alertEcsData$dns = alertEcsData.dns) === null || _alertEcsData$dns === void 0 ? void 0 : (_alertEcsData$dns$que2 = _alertEcsData$dns.question) === null || _alertEcsData$dns$que2 === void 0 ? void 0 : _alertEcsData$dns$que2.name) !== null && _alertEcsData$dns$que !== void 0 ? _alertEcsData$dns$que : ''
  }, {
    field: 'dns.question.type',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$dns$que3 = (_alertEcsData$dns2 = alertEcsData.dns) === null || _alertEcsData$dns2 === void 0 ? void 0 : (_alertEcsData$dns2$qu = _alertEcsData$dns2.question) === null || _alertEcsData$dns2$qu === void 0 ? void 0 : _alertEcsData$dns2$qu.type) !== null && _alertEcsData$dns$que3 !== void 0 ? _alertEcsData$dns$que3 : ''
  }, {
    field: 'user.id',
    operator: 'included',
    type: 'match',
    value: (_alertEcsData$user$id = (_alertEcsData$user = alertEcsData.user) === null || _alertEcsData$user === void 0 ? void 0 : _alertEcsData$user.id) !== null && _alertEcsData$user$id !== void 0 ? _alertEcsData$user$id : ''
  }];
  const entriesToAdd = () => {
    if (!isLinux) {
      if (processCodeSignature !== undefined && dllCodeSignature !== undefined) {
        return (0, _securitysolutionListUtils.addIdToEntries)(filterEmptyExceptionEntries(commonFields.concat(processCodeSignature, dllCodeSignature)));
      } else if (processCodeSignature !== undefined) {
        return (0, _securitysolutionListUtils.addIdToEntries)(filterEmptyExceptionEntries(commonFields.concat(processCodeSignature)));
      } else if (dllCodeSignature !== undefined) {
        return (0, _securitysolutionListUtils.addIdToEntries)(filterEmptyExceptionEntries(commonFields.concat(dllCodeSignature)));
      }
    }
    return (0, _securitysolutionListUtils.addIdToEntries)(filterEmptyExceptionEntries(commonFields));
  };
  return {
    ...(0, _securitysolutionListUtils.getNewExceptionItem)({
      listId,
      namespaceType: listNamespace,
      name
    }),
    entries: entriesToAdd()
  };
};

/**
 * Returns the default values from the alert data to autofill new endpoint exceptions
 */
exports.getPrepopulatedBehaviorException = getPrepopulatedBehaviorException;
const defaultEndpointExceptionItems = (listId, name, alertEcsData) => {
  var _alertEcsData$eventC, _alertEcsData$event;
  const eventCode = (_alertEcsData$eventC = alertEcsData['event.code']) !== null && _alertEcsData$eventC !== void 0 ? _alertEcsData$eventC : (_alertEcsData$event = alertEcsData.event) === null || _alertEcsData$event === void 0 ? void 0 : _alertEcsData$event.code;
  switch (eventCode) {
    case 'behavior':
      return [getPrepopulatedBehaviorException({
        listId,
        name,
        eventCode,
        alertEcsData
      })];
    case 'memory_signature':
      return [getPrepopulatedMemorySignatureException({
        listId,
        name,
        eventCode,
        alertEcsData
      })];
    case 'shellcode_thread':
      return [getPrepopulatedMemoryShellcodeException({
        listId,
        name,
        eventCode,
        alertEcsData
      })];
    case 'ransomware':
      return [getPrepopulatedRansomwareException({
        listId,
        name,
        eventCode,
        alertEcsData
      })];
    default:
      // By default return the standard prepopulated Endpoint Exception fields
      return [getPrepopulatedEndpointException({
        listId,
        name,
        eventCode: eventCode !== null && eventCode !== void 0 ? eventCode : '',
        alertEcsData
      })];
  }
};

/**
 * Adds user defined name to all new exceptionItems
 * @param exceptionItems new or existing ExceptionItem[]
 * @param name new exception item name
 */
exports.defaultEndpointExceptionItems = defaultEndpointExceptionItems;
const enrichNewExceptionItemsWithName = (exceptionItems, name) => {
  return exceptionItems.map(item => {
    return {
      ...item,
      name
    };
  });
};

/**
 * Modifies exception items to prepare for creating as rule_default
 * list items
 * @param exceptionItems new or existing ExceptionItem[]
 */
exports.enrichNewExceptionItemsWithName = enrichNewExceptionItemsWithName;
const enrichRuleExceptions = exceptionItems => {
  return exceptionItems.map(item => {
    return {
      ...(0, _securitysolutionListHooks.removeIdFromExceptionItemsEntries)(item),
      list_id: undefined,
      namespace_type: 'single'
    };
  });
};

/**
 * Prepares items to be added to shared exception lists
 * @param exceptionItems new or existing ExceptionItem[]
 * @param lists shared exception lists that were selected to add items to
 */
exports.enrichRuleExceptions = enrichRuleExceptions;
const enrichSharedExceptions = (exceptionItems, lists) => {
  return lists.flatMap(list => {
    return exceptionItems.map(item => {
      return {
        ...(0, _securitysolutionListHooks.removeIdFromExceptionItemsEntries)(item),
        list_id: list.list_id,
        namespace_type: list.namespace_type
      };
    });
  });
};

/**
 * Creates new Rule exception item with passed in entries
 */
exports.enrichSharedExceptions = enrichSharedExceptions;
const buildRuleExceptionWithConditions = ({
  name,
  exceptionEntries
}) => {
  return {
    ...(0, _securitysolutionListUtils.getNewExceptionItem)({
      listId: undefined,
      namespaceType: 'single',
      name
    }),
    entries: (0, _securitysolutionListUtils.addIdToEntries)(exceptionEntries)
  };
};

/**
 Generate exception conditions based on the highlighted fields of the alert that
 have corresponding values in the alert data.
 For the initial implementation the nested conditions are not considered
 Converting a singular value to a string or an array of strings
 is necessary because the "Match" or "Match any" operators
 are designed to operate with string value(s).
 */
exports.buildRuleExceptionWithConditions = buildRuleExceptionWithConditions;
const buildExceptionEntriesFromAlertFields = ({
  highlightedFields,
  alertData
}) => {
  return Object.values(highlightedFields).reduce((acc, field) => {
    var _get;
    const fieldKey = field.id;
    const fieldValue = (_get = (0, _lodash.get)(alertData, fieldKey)) !== null && _get !== void 0 ? _get : (0, _lodash.get)(alertData, (0, _highlighted_fields_config.getKibanaAlertIdField)(fieldKey));
    if (fieldValue !== null && fieldValue !== undefined) {
      const listOperatorType = Array.isArray(fieldValue) ? _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY : _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH;
      const fieldValueAsString = Array.isArray(fieldValue) ? fieldValue.map(String) : fieldValue.toString();
      acc.push({
        field: fieldKey,
        operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
        type: listOperatorType,
        value: fieldValueAsString
      });
    }
    return acc;
  }, []);
};
/**
 * Prepopulate the Rule Exception with the highlighted fields from the Alert's Summary.
 * @param alertData The Alert data object
 * @param exceptionItemName The name of the Exception Item
 * @returns A new Rule Exception Item with the highlighted fields as entries,
 */
exports.buildExceptionEntriesFromAlertFields = buildExceptionEntriesFromAlertFields;
const getPrepopulatedRuleExceptionWithHighlightFields = ({
  alertData,
  exceptionItemName,
  ruleCustomHighlightedFields
}) => {
  const highlightedFields = getAlertHighlightedFields(alertData, ruleCustomHighlightedFields);
  if (!highlightedFields.length) return null;
  const exceptionEntries = buildExceptionEntriesFromAlertFields({
    highlightedFields,
    alertData
  });
  if (!exceptionEntries.length) return null;
  return buildRuleExceptionWithConditions({
    name: exceptionItemName,
    exceptionEntries
  });
};

/**
  Filters out the irrelevant highlighted fields for Rule exceptions using
  1. The "highlightedFieldsPrefixToExclude" array
  2. Agent.id field in case the alert was not generated from Endpoint
  3. Threshold Rule
*/
exports.getPrepopulatedRuleExceptionWithHighlightFields = getPrepopulatedRuleExceptionWithHighlightFields;
const filterHighlightedFields = (fields, prefixesToExclude, alertData) => {
  return fields.filter(({
    id
  }) => {
    // Exclude agent.id field only if the agent type was not Endpoint
    if (id === _highlighted_fields_config.AGENT_ID) return isAlertFromEndpointEvent(alertData);
    return !prefixesToExclude.some(field => id.startsWith(field));
  });
};

/**
 * Retrieve the highlighted fields from the Alert Summary based on the following Alert properties:
 * * event.category
 * * event.code
 * * kibana.alert.rule.type
 * * Alert field ids filters
 * @param alertData The Alert data object
 */
exports.filterHighlightedFields = filterHighlightedFields;
const getAlertHighlightedFields = (alertData, ruleCustomHighlightedFields) => {
  const eventCategory = (0, _lodash.get)(alertData, _highlighted_fields_config.EVENT_CATEGORY);
  const eventCode = (0, _lodash.get)(alertData, _highlighted_fields_config.EVENT_CODE);
  const eventRuleType = (0, _lodash.get)(alertData, _highlighted_fields_config.KIBANA_ALERT_RULE_TYPE);
  const eventCategories = {
    primaryEventCategory: Array.isArray(eventCategory) ? eventCategory[0] : eventCategory,
    allEventCategories: Array.isArray(eventCategory) ? eventCategory : [eventCategory]
  };
  const fieldsToDisplay = (0, _get_alert_summary_rows.getHighlightedFieldsToDisplay)({
    eventCategories,
    eventCode,
    eventRuleType,
    ruleCustomHighlightedFields
  });
  return filterHighlightedFields(fieldsToDisplay, _highlighted_fields_config.highlightedFieldsPrefixToExclude, alertData);
};

/**
 * Checks to see if the given set of Timeline event detail items includes data that indicates its
 * an endpoint Alert
 */
exports.getAlertHighlightedFields = getAlertHighlightedFields;
const isAlertFromEndpointEvent = alertData => {
  // Check to see if a timeline event item is an Alert
  const isTimelineEventItemAnAlert = (0, _lodash.get)(alertData, _highlighted_fields_config.KIBANA_ALERT_RULE_UUID);
  if (!isTimelineEventItemAnAlert) return false;
  const agentTypes = (0, _lodash.get)(alertData, _highlighted_fields_config.AGENT_TYPE);
  const agentType = Array.isArray(agentTypes) ? agentTypes[0] : agentTypes;
  return agentType === _highlighted_fields_config.ENDPOINT_ALERT;
};
exports.isAlertFromEndpointEvent = isAlertFromEndpointEvent;