"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemCardConditions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _show_value_list_modal = require("../../../../value_list/components/show_value_list_modal");
var i18n = _interopRequireWildcard(require("./translations"));
var _value_with_space_warning = require("../value_with_space_warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/exception_item_card/conditions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OS_LABELS = Object.freeze({
  linux: i18n.OS_LINUX,
  mac: i18n.OS_MAC,
  macos: i18n.OS_MAC,
  windows: i18n.OS_WINDOWS
});
const EntryValueWrap = _styledComponents.default.span`
  white-space: pre-wrap;
`;
const OPERATOR_TYPE_LABELS_INCLUDED = Object.freeze({
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.NESTED]: i18n.CONDITION_OPERATOR_TYPE_NESTED,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY]: i18n.CONDITION_OPERATOR_TYPE_MATCH_ANY,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH]: i18n.CONDITION_OPERATOR_TYPE_MATCH,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD]: i18n.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS]: i18n.CONDITION_OPERATOR_TYPE_EXISTS,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST]: i18n.CONDITION_OPERATOR_TYPE_LIST
});
const OPERATOR_TYPE_LABELS_EXCLUDED = Object.freeze({
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY]: i18n.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH]: i18n.CONDITION_OPERATOR_TYPE_NOT_MATCH,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD]: i18n.CONDITION_OPERATOR_TYPE_WILDCARD_DOES_NOT_MATCH,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS]: i18n.CONDITION_OPERATOR_TYPE_DOES_NOT_EXIST,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST]: i18n.CONDITION_OPERATOR_TYPE_NOT_IN_LIST
});
const EuiFlexGroupNested = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeXL};
`;
const EuiFlexItemNested = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-bottom: 6px !important;
  margin-top: 6px !important;
`;
const StyledCondition = (0, _styledComponents.default)('span')`
  margin-right: 6px;
`;
const ExceptionItemCardConditions = exports.ExceptionItemCardConditions = /*#__PURE__*/(0, _react.memo)(({
  os,
  entries,
  dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const borderStyles = (0, _css.css)`
      border: ${euiTheme.border.thin};
    `;
  const panelStyles = (0, _css.cx)('eui-xScroll', borderStyles);
  const osLabel = (0, _react.useMemo)(() => {
    if (os != null && os.length > 0) {
      return os.map(osValue => {
        var _OS_LABELS;
        return (_OS_LABELS = OS_LABELS[osValue]) !== null && _OS_LABELS !== void 0 ? _OS_LABELS : osValue;
      }).join(', ');
    }
    return null;
  }, [os]);
  const getEntryValue = (type, value) => {
    var _EntryValueWrap;
    if (type === 'match_any' && Array.isArray(value)) {
      return value.map(currentValue => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(EntryValueWrap, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 13
        }
      }, currentValue)));
    } else if (type === 'list' && value) {
      return /*#__PURE__*/_react.default.createElement(_show_value_list_modal.ShowValueListModal, {
        shouldShowContentIfModalNotAvailable: true,
        listId: value.toString(),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 11
        }
      }, value);
    }
    return (_EntryValueWrap = /*#__PURE__*/_react.default.createElement(EntryValueWrap, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 14
      }
    }, value)) !== null && _EntryValueWrap !== void 0 ? _EntryValueWrap : '';
  };
  const getEntryOperator = (type, operator) => {
    var _OPERATOR_TYPE_LABELS, _OPERATOR_TYPE_LABELS2;
    if (type === 'nested') return '';
    return operator === 'included' ? (_OPERATOR_TYPE_LABELS = OPERATOR_TYPE_LABELS_INCLUDED[type]) !== null && _OPERATOR_TYPE_LABELS !== void 0 ? _OPERATOR_TYPE_LABELS : type : (_OPERATOR_TYPE_LABELS2 = OPERATOR_TYPE_LABELS_EXCLUDED[type]) !== null && _OPERATOR_TYPE_LABELS2 !== void 0 ? _OPERATOR_TYPE_LABELS2 : type;
  };
  const getNestedEntriesContent = (0, _react.useCallback)((type, nestedEntries) => {
    if (type === 'nested' && nestedEntries.length) {
      return nestedEntries.map(entry => {
        const {
          field: nestedField,
          type: nestedType,
          operator: nestedOperator
        } = entry;
        const nestedValue = 'value' in entry ? entry.value : '';
        return /*#__PURE__*/_react.default.createElement(EuiFlexGroupNested, {
          "data-test-subj": `${dataTestSubj}-nestedCondition`,
          key: nestedField + nestedType + nestedValue,
          direction: "row",
          alignItems: "center",
          gutterSize: "m",
          responsive: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
          iconType: "tokenNested",
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 143,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
          description: '',
          value: nestedField,
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 144,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
          description: getEntryOperator(nestedType, nestedOperator),
          value: getEntryValue(nestedType, nestedValue),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(_value_with_space_warning.ValueWithSpaceWarning, {
          value: nestedValue,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 152,
            columnNumber: 17
          }
        }));
      });
    }
  }, [dataTestSubj]);
  const getValue = (0, _react.useCallback)(entry => {
    if (entry.type === 'list') {
      return entry.list.id;
    } else {
      return 'value' in entry ? entry.value : '';
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: panelStyles,
    color: "subdued",
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, osLabel != null && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj}-os`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: '',
    value: i18n.CONDITION_OS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: i18n.CONDITION_OPERATOR_TYPE_MATCH,
    value: osLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }))), entries.map((entry, index) => {
    const {
      field,
      type
    } = entry;
    const value = getValue(entry);
    const nestedEntries = 'entries' in entry ? entry.entries : [];
    const operator = 'operator' in entry ? entry.operator : '';
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `${dataTestSubj}-condition`,
      key: field + type + value + index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-xScroll",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: index === 0 ? '' : /*#__PURE__*/_react.default.createElement(StyledCondition, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 40
        }
      }, i18n.CONDITION_AND),
      value: field,
      color: index === 0 ? 'primary' : 'subdued',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: getEntryOperator(type, operator),
      value: getEntryValue(type, value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_value_with_space_warning.ValueWithSpaceWarning, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 17
      }
    })), nestedEntries != null && getNestedEntriesContent(type, nestedEntries));
  }));
});
ExceptionItemCardConditions.displayName = 'ExceptionItemCardConditions';