"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRulePage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _use_confirm_validation_errors_modal = require("../../../../common/hooks/use_confirm_validation_errors_modal");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _utils = require("../../../../../common/detection_engine/utils");
var _rule_preview = require("../../components/rule_preview");
var _logic = require("../../../rule_management/logic");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _privileges = require("../../../../common/utils/privileges");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _user_info = require("../../../../detections/components/user_info");
var _step_panel = require("../../../rule_creation/components/step_panel");
var _step_about_rule = require("../../components/step_about_rule");
var _step_define_rule = require("../../components/step_define_rule");
var _use_experimental_feature_fields_transform = require("../../components/step_define_rule/use_experimental_feature_fields_transform");
var _step_schedule_rule = require("../../components/step_schedule_rule");
var _step_rule_actions = require("../../../rule_creation/components/step_rule_actions");
var _helpers = require("../rule_creation/helpers");
var _helpers2 = require("../../../common/helpers");
var ruleI18n = _interopRequireWildcard(require("../../../common/translations"));
var _types = require("../../../common/types");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("../../../../app/types");
var _utils2 = require("../../../common/utils");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_get_saved_query = require("../../../common/use_get_saved_query");
var _extract_validation_messages = require("../../../rule_creation/logic/extract_validation_messages");
var _validation_warning_codes = require("../../../rule_creation/constants/validation_warning_codes");
var _form = require("../form");
var _hooks = require("../../hooks");
var _ = require("..");
var _use_prebuilt_rules_customization_status = require("../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_customization_status");
var _alert_suppression_edit = require("../../../rule_creation/components/alert_suppression_edit");
var _use_prebuilt_rule_customization_upselling_message = require("../../../rule_management/logic/prebuilt_rules/use_prebuilt_rule_customization_upselling_message");
var _use_rule_update_callout = require("../../../rule_management/hooks/use_rule_update_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/pages/rule_editing/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditRulePageComponent = ({
  rule
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const {
    application,
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const {
    navigateToApp
  } = application;
  const {
    isRulesCustomizationEnabled
  } = (0, _use_prebuilt_rules_customization_status.usePrebuiltRulesCustomizationStatus)();
  const canEditRule = isRulesCustomizationEnabled || !rule.immutable;
  const prebuiltCustomizationUpsellingMessage = (0, _use_prebuilt_rule_customization_upselling_message.usePrebuiltRuleCustomizationUpsellingMessage)('prebuilt_rule_customization_description');
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const [activeStep, setActiveStep] = (0, _react.useState)(canEditRule ? _types.RuleStep.defineRule : _types.RuleStep.ruleActions);
  const {
    mutateAsync: updateRule,
    isLoading
  } = (0, _logic.useUpdateRule)();
  const [isRulePreviewVisible, setIsRulePreviewVisible] = (0, _react.useState)(true);
  const collapseFn = (0, _react.useRef)();
  const [isQueryBarValid, setIsQueryBarValid] = (0, _react.useState)(false);
  const backOptions = (0, _react.useMemo)(() => {
    var _rule$name;
    return {
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : ''),
      text: `${i18n.BACK_TO} ${(_rule$name = rule === null || rule === void 0 ? void 0 : rule.name) !== null && _rule$name !== void 0 ? _rule$name : ''}`,
      pageId: _types2.SecurityPageName.rules,
      dataTestSubj: 'ruleEditBackToRuleDetails'
    };
  }, [rule === null || rule === void 0 ? void 0 : rule.name, ruleId]);
  const [indicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_INDEX_KEY);
  const {
    aboutRuleData,
    defineRuleData,
    scheduleRuleData,
    ruleActionsData
  } = (0, _helpers2.getStepsData)({
    rule
  });
  const {
    defineStepForm,
    defineStepData,
    aboutStepForm,
    aboutStepData,
    scheduleStepForm,
    scheduleStepData,
    actionsStepForm,
    actionsStepData
  } = (0, _form.useRuleForms)({
    defineStepDefault: defineRuleData,
    aboutStepDefault: aboutRuleData,
    scheduleStepDefault: scheduleRuleData,
    actionsStepDefault: ruleActionsData
  });
  const {
    modal: confirmSavingWithWarningModal,
    confirmValidationErrors
  } = (0, _use_confirm_validation_errors_modal.useConfirmValidationErrorsModal)();
  const esqlQueryForAboutStep = (0, _hooks.useEsqlQueryForAboutStep)({
    defineStepData,
    activeStep
  });
  const esqlIndex = (0, _hooks.useEsqlIndex)(defineStepData.queryBar.query.query, defineStepData.ruleType);
  const memoizedIndex = (0, _react.useMemo)(() => (0, _utils.isEsqlRule)(defineStepData.ruleType) ? esqlIndex : defineStepData.index, [defineStepData.index, esqlIndex, defineStepData.ruleType]);
  const loading = userInfoLoading || listsConfigLoading;
  const {
    isSavedQueryLoading,
    savedQuery
  } = (0, _use_get_saved_query.useGetSavedQuery)({
    savedQueryId: 'saved_id' in rule ? rule.saved_id : undefined,
    ruleType: rule === null || rule === void 0 ? void 0 : rule.type
  });

  // Since in the edit step we start with an existing rule, we assume that
  // the steps are valid if isValid is undefined. Once the user triggers validation by
  // trying to submit the edits, the isValid statuses will be tracked and the callout appears
  // if some steps are invalid
  const stepIsValid = (0, _react.useCallback)(step => {
    var _defineStepForm$isVal, _aboutStepForm$isVali, _scheduleStepForm$isV, _actionsStepForm$isVa;
    switch (step) {
      case _types.RuleStep.defineRule:
        return (_defineStepForm$isVal = defineStepForm.isValid) !== null && _defineStepForm$isVal !== void 0 ? _defineStepForm$isVal : true;
      case _types.RuleStep.aboutRule:
        return (_aboutStepForm$isVali = aboutStepForm.isValid) !== null && _aboutStepForm$isVali !== void 0 ? _aboutStepForm$isVali : true;
      case _types.RuleStep.scheduleRule:
        return (_scheduleStepForm$isV = scheduleStepForm.isValid) !== null && _scheduleStepForm$isV !== void 0 ? _scheduleStepForm$isV : true;
      case _types.RuleStep.ruleActions:
        return (_actionsStepForm$isVa = actionsStepForm.isValid) !== null && _actionsStepForm$isVa !== void 0 ? _actionsStepForm$isVa : true;
      default:
        return true;
    }
  }, [aboutStepForm.isValid, actionsStepForm.isValid, defineStepForm.isValid, scheduleStepForm.isValid]);
  const invalidSteps = _utils2.ruleStepsOrder.filter(step => {
    return !stepIsValid(step);
  });
  const actionMessageParams = (0, _react.useMemo)(() => (0, _helpers2.getActionMessageParams)(rule === null || rule === void 0 ? void 0 : rule.type), [rule === null || rule === void 0 ? void 0 : rule.type]);
  const {
    indexPattern,
    isIndexPatternLoading
  } = (0, _form.useRuleIndexPattern)({
    dataSourceType: defineStepData.dataSourceType,
    index: memoizedIndex,
    dataViewId: defineStepData.dataViewId
  });
  const customizationDisabledTooltip = !canEditRule && !isRulesCustomizationEnabled ? prebuiltCustomizationUpsellingMessage : undefined;
  const tabs = (0, _react.useMemo)(() => [{
    'data-test-subj': 'edit-rule-define-tab',
    id: _types.RuleStep.defineRule,
    name: ruleI18n.DEFINITION,
    disabled: !canEditRule,
    tooltip: customizationDisabledTooltip,
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: activeStep === _types.RuleStep.defineRule ? undefined : 'none'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading || isSavedQueryLoading,
      title: ruleI18n.DEFINITION,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 13
      }
    }, !isSavedQueryLoading && /*#__PURE__*/_react.default.createElement(_step_define_rule.StepDefineRule, {
      isLoading: loading || isLoading || isSavedQueryLoading,
      isUpdateView: true,
      indicesConfig: indicesConfig,
      defaultSavedQuery: savedQuery,
      form: defineStepForm,
      key: "defineStep",
      indexPattern: indexPattern,
      isIndexPatternLoading: isIndexPatternLoading,
      isQueryBarValid: isQueryBarValid,
      setIsQueryBarValid: setIsQueryBarValid,
      index: memoizedIndex,
      threatIndex: defineStepData.threatIndex,
      alertSuppressionFields: defineStepData[_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME],
      dataSourceType: defineStepData.dataSourceType,
      shouldLoadQueryDynamically: defineStepData.shouldLoadQueryDynamically,
      queryBarTitle: defineStepData.queryBar.title,
      queryBarSavedId: defineStepData.queryBar.saved_id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 15
      }
    })))
  }, {
    'data-test-subj': 'edit-rule-about-tab',
    id: _types.RuleStep.aboutRule,
    name: ruleI18n.ABOUT,
    disabled: !canEditRule,
    tooltip: customizationDisabledTooltip,
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: activeStep === _types.RuleStep.aboutRule ? undefined : 'none'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading,
      title: ruleI18n.ABOUT,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 13
      }
    }, aboutStepData != null && defineStepData != null && /*#__PURE__*/_react.default.createElement(_step_about_rule.StepAboutRule, {
      isLoading: isLoading,
      isUpdateView: true,
      ruleType: defineStepData.ruleType,
      machineLearningJobId: defineStepData.machineLearningJobId,
      index: memoizedIndex,
      dataViewId: defineStepData.dataViewId,
      timestampOverride: aboutStepData.timestampOverride,
      form: aboutStepForm,
      esqlQuery: esqlQueryForAboutStep,
      key: "aboutStep",
      ruleSource: rule.rule_source,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 15
      }
    })))
  }, {
    'data-test-subj': 'edit-rule-schedule-tab',
    id: _types.RuleStep.scheduleRule,
    name: ruleI18n.SCHEDULE,
    disabled: !canEditRule,
    tooltip: customizationDisabledTooltip,
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: activeStep === _types.RuleStep.scheduleRule ? undefined : 'none'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading,
      title: ruleI18n.SCHEDULE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 13
      }
    }, scheduleStepData != null && /*#__PURE__*/_react.default.createElement(_step_schedule_rule.StepScheduleRule, {
      isLoading: isLoading,
      isUpdateView: true,
      form: scheduleStepForm,
      key: "scheduleStep",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 15
      }
    })))
  }, {
    'data-test-subj': 'edit-rule-actions-tab',
    id: _types.RuleStep.ruleActions,
    name: ruleI18n.ACTIONS,
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: activeStep === _types.RuleStep.ruleActions ? undefined : 'none'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 13
      }
    }, actionsStepData != null && /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActions, {
      ruleId: rule === null || rule === void 0 ? void 0 : rule.id,
      ruleTypeId: _securitysolutionRules.ruleTypeMappings[rule === null || rule === void 0 ? void 0 : rule.type],
      isLoading: isLoading,
      isUpdateView: true,
      actionMessageParams: actionMessageParams,
      summaryActionMessageParams: actionMessageParams,
      form: actionsStepForm,
      key: "actionsStep",
      ruleInterval: scheduleStepData.interval,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 333,
        columnNumber: 15
      }
    })))
  }], [canEditRule, customizationDisabledTooltip, activeStep, loading, isSavedQueryLoading, isLoading, indicesConfig, savedQuery, defineStepForm, indexPattern, isIndexPatternLoading, isQueryBarValid, memoizedIndex, defineStepData, aboutStepData, aboutStepForm, esqlQueryForAboutStep, rule.rule_source, rule === null || rule === void 0 ? void 0 : rule.id, rule === null || rule === void 0 ? void 0 : rule.type, scheduleStepData, scheduleStepForm, actionsStepData, actionMessageParams, actionsStepForm]);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const defineFieldsTransform = (0, _use_experimental_feature_fields_transform.useExperimentalFeatureFieldsTransform)();
  const saveChanges = (0, _react.useCallback)(async () => {
    var _updatedRule$name;
    startTransaction({
      name: _user_actions.SINGLE_RULE_ACTIONS.SAVE
    });
    const localDefineStepData = defineFieldsTransform({
      ...defineStepData
    });
    const updatedRule = await updateRule({
      ...(0, _helpers.formatRule)(localDefineStepData, aboutStepData, scheduleStepData, actionsStepData, triggersActionsUi.actionTypeRegistry, rule === null || rule === void 0 ? void 0 : rule.exceptions_list),
      ...(ruleId ? {
        id: ruleId
      } : {})
    });
    addSuccess(i18n.SUCCESSFULLY_SAVED_RULE((_updatedRule$name = updatedRule === null || updatedRule === void 0 ? void 0 : updatedRule.name) !== null && _updatedRule$name !== void 0 ? _updatedRule$name : ''));
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
    });
  }, [aboutStepData, actionsStepData, defineStepData, defineFieldsTransform, addSuccess, navigateToApp, rule === null || rule === void 0 ? void 0 : rule.exceptions_list, ruleId, scheduleStepData, startTransaction, triggersActionsUi.actionTypeRegistry, updateRule]);
  const onSubmit = (0, _react.useCallback)(async () => {
    const actionsStepFormValid = await actionsStepForm.validate();
    if (!canEditRule) {
      // Since users cannot edit Define, About and Schedule tabs of the rule, we skip validation of those to avoid
      // user confusion of seeing that those tabs have error and not being able to see or do anything about that.
      if (actionsStepFormValid) {
        await saveChanges();
      }
      return;
    }
    const defineStepFormValid = await defineStepForm.validate();
    const aboutStepFormValid = await aboutStepForm.validate();
    const scheduleStepFormValid = await scheduleStepForm.validate();
    if (!defineStepFormValid || !aboutStepFormValid || !scheduleStepFormValid || !actionsStepFormValid) {
      return;
    }
    const defineRuleWarnings = defineStepForm.getValidationWarnings();
    const aboutRuleWarnings = aboutStepForm.getValidationWarnings();
    const scheduleRuleWarnings = scheduleStepForm.getValidationWarnings();
    const ruleActionsWarnings = actionsStepForm.getValidationWarnings();
    const warnings = (0, _extract_validation_messages.extractValidationMessages)([...defineRuleWarnings, ...aboutRuleWarnings, ...scheduleRuleWarnings, ...ruleActionsWarnings], _validation_warning_codes.VALIDATION_WARNING_CODE_FIELD_NAME_MAP);
    if (!(await confirmValidationErrors(warnings))) {
      return;
    }
    await saveChanges();
  }, [actionsStepForm, canEditRule, defineStepForm, aboutStepForm, scheduleStepForm, confirmValidationErrors, saveChanges]);
  const onTabClick = (0, _react.useCallback)(async tab => {
    const targetStep = tab.id;
    setActiveStep(targetStep);
  }, []);
  const renderTabs = () => {
    return tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      key: index,
      position: "top",
      content: tab.tooltip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 470,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => onTabClick(tab),
      isSelected: tab.id === activeStep,
      disabled: tab.disabled,
      "data-test-subj": tab['data-test-subj'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 471,
        columnNumber: 9
      }
    }, tab.name)));
  };
  const goToDetailsRule = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
    });
  }, [navigateToApp, ruleId]);
  const upgradeCallout = (0, _use_rule_update_callout.useRuleUpdateCallout)({
    rule,
    message: ruleI18n.HAS_RULE_UPDATE_EDITING_CALLOUT_MESSAGE,
    actionButton: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: goToDetailsRule,
      "data-test-subj": "ruleEditingUpdateRuleCalloutButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 498,
        columnNumber: 7
      }
    }, ruleI18n.HAS_RULE_UPDATE_EDITING_CALLOUT_BUTTON)
  });
  const verifyRuleDefinitionForPreview = (0, _react.useCallback)(() => defineStepForm.validate(), [defineStepForm]);
  if ((0, _helpers2.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  } else if (!(0, _privileges.hasUserCRUDPermission)(canUserCRUD)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, confirmSavingWithWarningModal, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 533,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 534,
      columnNumber: 9
    }
  }, (EuiResizablePanel, EuiResizableButton, {
    togglePanel
  }) => {
    collapseFn.current = () => togglePanel === null || togglePanel === void 0 ? void 0 : togglePanel('preview', {
      direction: 'left'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      initialSize: 70,
      minSize: '40%',
      mode: "main",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 539,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: "spaceAround",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 540,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_helpers2.MaxWidthEuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 541,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_.CustomHeaderPageMemo, {
      backOptions: backOptions,
      isLoading: isLoading,
      title: i18n.PAGE_TITLE,
      isRulePreviewVisible: isRulePreviewVisible,
      setIsRulePreviewVisible: setIsRulePreviewVisible,
      togglePanel: togglePanel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 542,
        columnNumber: 23
      }
    }), isRulesCustomizationEnabled && upgradeCallout, invalidSteps.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18n.SORRY_ERRORS,
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 552,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.rule.editRule.errorMsgDescription",
      defaultMessage: "You have an invalid input in {countError, plural, one {this tab} other {these tabs}}: {tabHasError}",
      values: {
        countError: invalidSteps.length,
        tabHasError: invalidSteps.map(t => {
          if (t === _types.RuleStep.aboutRule) {
            return ruleI18n.ABOUT;
          } else if (t === _types.RuleStep.defineRule) {
            return ruleI18n.DEFINITION;
          } else if (t === _types.RuleStep.scheduleRule) {
            return ruleI18n.SCHEDULE;
          } else if (t === _types.RuleStep.ruleActions) {
            return ruleI18n.RULE_ACTIONS;
          }
          return t;
        }).join(', ')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 553,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 577,
        columnNumber: 23
      }
    }, renderTabs()), tabs.map(tab => tab.content), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 581,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      justifyContent: "flexEnd",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 583,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 589,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "cross",
      onClick: goToDetailsRule,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 590,
        columnNumber: 27
      }
    }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 595,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "ruleEditSubmitButton",
      fill: true,
      onClick: onSubmit,
      iconType: "save",
      isLoading: isLoading,
      isDisabled: loading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 596,
        columnNumber: 27
      }
    }, i18n.SAVE_CHANGES)))))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 611,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: 'preview',
      mode: "collapsible",
      initialSize: 30,
      minSize: '20%',
      onToggleCollapsed: () => setIsRulePreviewVisible(isVisible => !isVisible),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 613,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_preview.RulePreview, {
      verifyRuleDefinition: verifyRuleDefinitionForPreview,
      defineRuleData: defineStepData,
      aboutRuleData: aboutStepData,
      scheduleRuleData: scheduleStepData,
      exceptionsList: rule === null || rule === void 0 ? void 0 : rule.exceptions_list,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 620,
        columnNumber: 19
      }
    })));
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types2.SecurityPageName.rules,
    state: {
      ruleName: rule === null || rule === void 0 ? void 0 : rule.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 7
    }
  }));
};
const EditRulePageWrapper = () => {
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    data: rule
  } = (0, _logic.useRule)(ruleId, true);
  return rule != null ? /*#__PURE__*/_react.default.createElement(EditRulePageComponent, {
    rule: rule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 642,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
const EditRulePage = exports.EditRulePage = /*#__PURE__*/(0, _react.memo)(EditRulePageWrapper);