"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingFieldsStrategySelector = MissingFieldsStrategySelector;
var _react = _interopRequireWildcard(require("react"));
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _shared_imports = require("../../../../../shared_imports");
var _suppression_info_icon = require("./suppression_info_icon");
var _fields = require("../constants/fields");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/alert_suppression_edit/components/missing_fields_strategy_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function MissingFieldsStrategySelector({
  disabled
}) {
  const radioFieldProps = (0, _react.useMemo)(() => ({
    options: ALERT_SUPPRESSION_MISSING_FIELDS_STRATEGY_OPTIONS,
    'data-test-subj': 'suppressionMissingFieldsOptions',
    disabled
  }), [disabled]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: _fields.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME,
    component: _components.RadioGroupField,
    componentProps: EUI_FORM_ROW_PROPS,
    euiFieldProps: radioFieldProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  });
}
const EUI_FORM_ROW_PROPS = {
  label: /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, i18n.ALERT_SUPPRESSION_MISSING_FIELDS_LABEL, " ", /*#__PURE__*/_react.default.createElement(_suppression_info_icon.SuppressionInfoIcon, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 53
    }
  })),
  'data-test-subj': 'alertSuppressionMissingFields'
};
const ALERT_SUPPRESSION_MISSING_FIELDS_STRATEGY_OPTIONS = [{
  id: _detection_engine.AlertSuppressionMissingFieldsStrategyEnum.suppress,
  label: i18n.ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION
}, {
  id: _detection_engine.AlertSuppressionMissingFieldsStrategyEnum.doNotSuppress,
  label: i18n.ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION
}];