"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsLandingPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _landing_links = require("@kbn/security-solution-navigation/landing_links");
var _use_contract_component = require("../../../common/hooks/use_contract_component");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _constants = require("../../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
var _nav_links = require("../../../common/links/nav_links");
var _title = require("../../../common/components/header_page/title");
var _helpers = require("../../../common/components/links/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _telemetry = require("../../../common/lib/telemetry");
var _translations2 = require("../translations");
var _use_create_security_dashboard_link = require("../../hooks/use_create_security_dashboard_link");
var _link_to = require("../../../common/components/link_to");
var _global_query_string = require("../../../common/utils/global_query_string");
var _trackers = require("../../../common/lib/telemetry/trackers");
var _dashboard_context = require("../../context/dashboard_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/dashboards/pages/landing_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getInitialFilterString = securityTags => {
  if (!securityTags) {
    return;
  }
  const uniqueQuerySet = securityTags === null || securityTags === void 0 ? void 0 : securityTags.reduce((acc, {
    name
  }) => {
    const nameString = `"${name}"`;
    if (name && !acc.has(nameString)) {
      acc.add(nameString);
    }
    return acc;
  }, new Set());
  const query = [...uniqueQuerySet].join(' or');
  return `tag:(${query})`;
};
const Header = ({
  canCreateDashboard
}) => {
  const {
    isLoading,
    url
  } = (0, _use_create_security_dashboard_link.useCreateSecurityDashboardLink)();
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: _translations2.DASHBOARDS_PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })), canCreateDashboard && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.LinkButton, {
    isDisabled: isLoading,
    color: "primary",
    fill: true,
    iconType: "plusInCircle",
    href: url,
    onClick: ev => {
      ev.preventDefault();
      (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.CREATE_DASHBOARD}`);
      navigateTo({
        url
      });
    },
    "data-test-subj": "createDashboardButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, i18n.DASHBOARDS_PAGE_CREATE_BUTTON)));
};
const DashboardsLandingPage = () => {
  var _useRootNavLink;
  const {
    DashboardsLandingCallout
  } = (0, _use_contract_component.useContractComponents)();
  const {
    links = []
  } = (_useRootNavLink = (0, _nav_links.useRootNavLink)(_constants.SecurityPageName.dashboards)) !== null && _useRootNavLink !== void 0 ? _useRootNavLink : {};
  const urlState = (0, _global_query_string.useGlobalQueryString)();
  const {
    show: canReadDashboard,
    createNew: canCreateDashboard
  } = (0, _kibana.useCapabilities)('dashboard_v2');
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const getSecuritySolutionDashboardUrl = (0, _react.useCallback)(id => `${getSecuritySolutionUrl({
    deepLinkId: _constants.SecurityPageName.dashboards,
    path: id
  })}`, [getSecuritySolutionUrl]);
  const goToDashboard = (0, _react.useCallback)(dashboardId => {
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.TELEMETRY_EVENT.DASHBOARD);
    navigateTo({
      url: getSecuritySolutionUrl({
        deepLinkId: _constants.SecurityPageName.dashboards,
        path: dashboardId !== null && dashboardId !== void 0 ? dashboardId : 'create'
      })
    });
  }, [getSecuritySolutionUrl, navigateTo]);
  const securityTags = (0, _dashboard_context.useSecurityTags)();
  const securityTagsExist = securityTags && (securityTags === null || securityTags === void 0 ? void 0 : securityTags.length) > 0;
  const initialFilter = (0, _react.useMemo)(() => getInitialFilterString(securityTags), [securityTags]);
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Header, {
    canCreateDashboard: canCreateDashboard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), DashboardsLandingCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DashboardsLandingCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksImageCards, {
    items: links,
    urlState: urlState,
    onLinkClick: _trackers.trackLandingLinkClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }), canReadDashboard && securityTagsExist && initialFilter && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, i18n.DASHBOARDS_PAGE_SECTION_CUSTOM)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_public.DashboardListingTable, {
    disableCreateDashboardButton: !canCreateDashboard,
    getDashboardUrl: getSecuritySolutionDashboardUrl,
    goToDashboard: goToDashboard,
    initialFilter: initialFilter,
    urlStateEnabled: false,
    showCreateDashboardButton: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  })), canReadDashboard && !securityTagsExist && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      "data-test-subj": "dashboardLoadingIcon",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.dashboards,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }));
};
exports.DashboardsLandingPage = DashboardsLandingPage;