"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecurityTags = exports.useDashboardContext = exports.DashboardContextProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_fetch_security_tags = require("../containers/use_fetch_security_tags");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/dashboards/context/dashboard_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DashboardContext = /*#__PURE__*/_react.default.createContext({
  securityTags: null
});
const DashboardContextProvider = ({
  children
}) => {
  const {
    tags,
    isLoading
  } = (0, _use_fetch_security_tags.useFetchSecurityTags)();
  const securityTags = isLoading || !tags ? null : tags;
  return /*#__PURE__*/_react.default.createElement(DashboardContext.Provider, {
    value: {
      securityTags
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 10
    }
  }, children);
};
exports.DashboardContextProvider = DashboardContextProvider;
const useDashboardContext = () => {
  const context = _react.default.useContext(DashboardContext);
  if (!context) {
    throw new Error('useDashboardContext must be used within a DashboardContextProvider');
  }
  return context;
};
exports.useDashboardContext = useDashboardContext;
const useSecurityTags = () => {
  const context = useDashboardContext();
  return context.securityTags;
};
exports.useSecurityTags = useSecurityTags;