"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withLazyHook = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/with_lazy_hook/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * HOC to wrap a component with a lazy-loaded hook.
 * This allows the component to use a hook that is imported dynamically,
 * which can be useful for reducing the initial bundle size.
 *
 * @param Component - The component to wrap, it have to accept the hook as a prop (e.g. { useSomeHook: UseSomeHook }).
 * @param hookImport - A function that returns a promise resolving to an object with the hook's prop (e.g. { useSomeHook: () => {} }).
 * @param fallback - A fallback React node to render while the hook is being loaded.
 */
const withLazyHook = (Component, hookImport, fallback = null) => {
  return /*#__PURE__*/_react.default.memo(function WithLazyHook(props) {
    const [lazyHookProp, setLazyHookProp] = (0, _react.useState)();
    (0, _react.useEffect)(() => {
      hookImport().then(hook => {
        setLazyHookProp(() => hook);
      });
    }, []);
    return lazyHookProp ? /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, lazyHookProp, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 27
      }
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fallback);
  });
};
exports.withLazyHook = withLazyHook;