"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UtilityBarAction = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _link_icon = require("../link_icon");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/utility_bar/utility_bar_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LoadingButtonEmpty = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    &.euiButtonEmpty {
      height: ${theme.eui.euiSize};
    }
  `}
`;
const Popover = /*#__PURE__*/_react.default.memo(({
  children,
  color,
  iconSide,
  iconSize,
  iconType,
  popoverContent,
  disabled,
  ownFocus,
  dataTestSubj,
  popoverPanelPaddingSize,
  onClick
}) => {
  const [popoverState, setPopoverState] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setPopoverState(false), [setPopoverState]);
  const handleLinkIconClick = (0, _react.useCallback)(() => {
    onClick === null || onClick === void 0 ? void 0 : onClick();
    setPopoverState(!popoverState);
  }, [popoverState, onClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: ownFocus,
    panelPaddingSize: popoverPanelPaddingSize,
    button: /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
      dataTestSubj: dataTestSubj,
      color: color,
      iconSide: iconSide,
      iconSize: iconSize,
      iconType: iconType,
      disabled: disabled,
      onClick: handleLinkIconClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }, children),
    closePopover: closePopover,
    isOpen: popoverState,
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, popoverContent === null || popoverContent === void 0 ? void 0 : popoverContent(closePopover));
});
Popover.displayName = 'Popover';
const UtilityBarAction = exports.UtilityBarAction = /*#__PURE__*/_react.default.memo(({
  children,
  color,
  dataTestSubj,
  disabled,
  href,
  iconSide,
  iconSize,
  iconType,
  ownFocus,
  onClick,
  popoverContent,
  popoverPanelPaddingSize,
  inProgress
}) => {
  if (inProgress) {
    return /*#__PURE__*/_react.default.createElement(_styles.BarAction, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(LoadingButtonEmpty, {
      "data-test-subj": `${dataTestSubj}-progress`,
      size: "xs",
      className: "eui-alignTop",
      isLoading: true,
      iconSide: "right",
      flush: "both",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, children));
  }
  return /*#__PURE__*/_react.default.createElement(_styles.BarAction, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, popoverContent ? /*#__PURE__*/_react.default.createElement(Popover, {
    dataTestSubj: `${dataTestSubj}-popover`,
    disabled: disabled,
    color: color,
    iconSide: iconSide,
    iconSize: iconSize,
    iconType: iconType,
    ownFocus: ownFocus,
    popoverPanelPaddingSize: popoverPanelPaddingSize,
    popoverContent: popoverContent,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, children) : /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
    color: color,
    dataTestSubj: `${dataTestSubj}-linkIcon`,
    disabled: disabled,
    href: href,
    iconSide: iconSide,
    iconSize: iconSize,
    iconType: iconType,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, children));
});
UtilityBarAction.displayName = 'UtilityBarAction';