"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListItemComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("./helpers");
var _entry_item = require("./entry_item");
var _entry_delete_button = require("./entry_delete_button");
var _and_badge = require("./and_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/threat_match/list_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MyOverflowContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
  width: 100%;
`;
const ListItemComponent = exports.ListItemComponent = /*#__PURE__*/_react.default.memo(({
  listItem,
  listItemIndex,
  indexPattern,
  threatIndexPatterns,
  isOnlyItem,
  andLogicIncluded,
  onDeleteEntryItem,
  onChangeEntryItem
}) => {
  const handleEntryChange = (0, _react.useCallback)((entry, entryIndex) => {
    const updatedEntries = [...listItem.entries.slice(0, entryIndex), {
      ...entry
    }, ...listItem.entries.slice(entryIndex + 1)];
    const updatedEntryItem = {
      ...listItem,
      entries: updatedEntries
    };
    onChangeEntryItem(updatedEntryItem, listItemIndex);
  }, [onChangeEntryItem, listItem, listItemIndex]);
  const handleDeleteEntry = (0, _react.useCallback)(entryIndex => {
    const updatedEntryItem = (0, _helpers.getUpdatedEntriesOnDelete)(listItem, entryIndex);
    onDeleteEntryItem(updatedEntryItem, listItemIndex);
  }, [listItem, onDeleteEntryItem, listItemIndex]);
  const entries = (0, _react.useMemo)(() => indexPattern != null && listItem.entries.length > 0 ? (0, _helpers.getFormattedEntries)(indexPattern, threatIndexPatterns, listItem.entries) : [], [listItem.entries, indexPattern, threatIndexPatterns]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "entriesContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, andLogicIncluded && /*#__PURE__*/_react.default.createElement(_and_badge.AndBadgeComponent, {
    entriesLength: listItem.entries.length,
    entryItemIndex: listItemIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(MyOverflowContainer, {
    grow: 6,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, entries.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.id,
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(MyOverflowContainer, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_entry_item.EntryItem, {
    entry: item,
    threatIndexPatterns: threatIndexPatterns,
    indexPattern: indexPattern,
    showLabel: listItemIndex === 0 && index === 0,
    onChange: handleEntryChange,
    doesNotMatchDisabled: listItem.entries.length === 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_entry_delete_button.EntryDeleteButtonComponent, {
    entries: listItem.entries,
    isOnlyItem: isOnlyItem,
    entryIndex: item.entryIndex,
    itemIndex: listItemIndex,
    onDelete: handleDeleteEntry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 21
    }
  }))))))));
});
ListItemComponent.displayName = 'ListItem';