"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomaliesNetworkTableColumnsCurated = exports.getAnomaliesNetworkTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../tables/helpers");
var _create_compound_key = require("./create_compound_key");
var _links = require("../../links");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../../../../explore/network/store/model");
var _get_anomalies_table_columns = require("./get_anomalies_table_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/tables/get_anomalies_network_table_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getAnomaliesNetworkTableColumns = (startDate, endDate, flowTarget) => [{
  name: i18n.NETWORK_NAME,
  field: 'ip',
  sortable: true,
  render: (ip, anomaliesByNetwork) => (0, _helpers.getRowItemsWithActions)({
    values: [ip],
    fieldName: anomaliesByNetwork.type,
    idPrefix: `anomalies-network-table-ip-${(0, _create_compound_key.createCompoundAnomalyKey)(anomaliesByNetwork.anomaly)}`,
    render: item => /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
      ip: item,
      flowTarget: flowTarget,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 27
      }
    })
  })
}, ...(0, _get_anomalies_table_columns.getAnomaliesDefaultTableColumns)(startDate, endDate)];
exports.getAnomaliesNetworkTableColumns = getAnomaliesNetworkTableColumns;
const getAnomaliesNetworkTableColumnsCurated = (pageType, startDate, endDate, flowTarget) => {
  const columns = getAnomaliesNetworkTableColumns(startDate, endDate, flowTarget);

  // Columns to exclude from ip details pages
  if (pageType === _model.NetworkType.details) {
    return columns.filter(column => column.name !== i18n.NETWORK_NAME);
  } else {
    return columns;
  }
};
exports.getAnomaliesNetworkTableColumnsCurated = getAnomaliesNetworkTableColumnsCurated;