"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlCapabilitiesProvider = exports.MlCapabilitiesContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _empty_ml_capabilities = require("../../../../../common/machine_learning/empty_ml_capabilities");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _kibana = require("../../../lib/kibana");
var _use_get_ml_capabilities = require("../hooks/use_get_ml_capabilities");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/permissions/ml_capabilities_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyMlCapabilitiesProvider = {
  ..._empty_ml_capabilities.emptyMlCapabilities,
  capabilitiesFetched: false
};
const MlCapabilitiesContext = exports.MlCapabilitiesContext = /*#__PURE__*/_react.default.createContext(emptyMlCapabilitiesProvider);
MlCapabilitiesContext.displayName = 'MlCapabilitiesContext';
const MlCapabilitiesProvider = exports.MlCapabilitiesProvider = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const [capabilities, setCapabilities] = (0, _react.useState)(emptyMlCapabilitiesProvider);
  const http = (0, _kibana.useHttp)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    start,
    result,
    error
  } = (0, _use_get_ml_capabilities.useGetMlCapabilities)();
  (0, _react.useEffect)(() => {
    start({
      http
    });
  }, [http, start]);
  (0, _react.useEffect)(() => {
    if (result) {
      setCapabilities({
        ...result,
        capabilitiesFetched: true
      });
    }
  }, [result]);
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title: i18n.MACHINE_LEARNING_PERMISSIONS_FAILURE
      });
    }
  }, [addError, error]);
  return /*#__PURE__*/_react.default.createElement(MlCapabilitiesContext.Provider, {
    value: capabilities,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, children);
});
MlCapabilitiesProvider.displayName = 'MlCapabilitiesProvider';