"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchJobsSummaryQuery = exports.useFetchJobsSummaryQuery = exports.GET_JOBS_SUMMARY_QUERY_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _get_jobs_summary = require("../api/get_jobs_summary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_MINUTE = 60000;
const GET_JOBS_SUMMARY_QUERY_KEY = exports.GET_JOBS_SUMMARY_QUERY_KEY = ['POST', '/api/ml/jobs/jobs_summary'];
const useFetchJobsSummaryQuery = (queryArgs, options) => {
  return (0, _reactQuery.useQuery)([GET_JOBS_SUMMARY_QUERY_KEY, queryArgs], async ({
    signal
  }) => (0, _get_jobs_summary.getJobsSummary)({
    signal,
    ...queryArgs
  }), {
    refetchIntervalInBackground: false,
    staleTime: ONE_MINUTE * 5,
    retry: false,
    ...options
  });
};
exports.useFetchJobsSummaryQuery = useFetchJobsSummaryQuery;
const useInvalidateFetchJobsSummaryQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(GET_JOBS_SUMMARY_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchJobsSummaryQuery = useInvalidateFetchJobsSummaryQuery;