"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingPrivilegesCallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _objectHash = _interopRequireDefault(require("object-hash"));
var _callouts = require("../callouts");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_missing_privileges = require("../../hooks/use_missing_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/missing_privileges/missing_privileges_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Callout that displays a Callout when the user has missing privileges.
 */
const MissingPrivilegesCallOut = exports.MissingPrivilegesCallOut = /*#__PURE__*/(0, _react.memo)(() => {
  const missingPrivileges = (0, _use_missing_privileges.useMissingPrivileges)();
  const MissingPrivilegesMessage = (0, _react.useMemo)(() => {
    const hasMissingPrivileges = missingPrivileges.indexPrivileges.length > 0 || missingPrivileges.featurePrivileges.length > 0;
    if (!hasMissingPrivileges) {
      return null;
    }
    const missingPrivilegesHash = (0, _objectHash.default)(missingPrivileges);
    return {
      type: 'primary',
      /**
       * Use privileges hash as a part of the message id.
       * We want to make sure that the user will see the
       * callout message in case his privileges change.
       * The previous click on Dismiss should not affect that.
       */
      id: `missing-user-privileges-${missingPrivilegesHash}`,
      title: i18n.MISSING_PRIVILEGES_CALLOUT_TITLE,
      description: i18n.missingPrivilegesCallOutBody(missingPrivileges)
    };
  }, [missingPrivileges]);
  return MissingPrivilegesMessage && /*#__PURE__*/_react.default.createElement(_callouts.CallOutSwitcher, {
    namespace: "detections",
    condition: true,
    message: MissingPrivilegesMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  });
});
MissingPrivilegesCallOut.displayName = 'MissingPrivilegesCallOut';