"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionIconItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("../../../timelines/components/timeline/styles");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/header_actions/action_icon_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ActionIconItemComponent = ({
  width = _.DEFAULT_ACTION_BUTTON_WIDTH,
  dataTestSubj,
  content,
  ariaLabel,
  iconType = '',
  isDisabled = false,
  onClick,
  children,
  buttonType = 'icon'
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, buttonType === 'icon' && /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
  textAlign: "center",
  width: width,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 9
  }
}, children !== null && children !== void 0 ? children : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  "data-test-subj": `${dataTestSubj}-tool-tip`,
  content: content,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "aria-label": ariaLabel,
  "data-test-subj": `${dataTestSubj}-button`,
  iconType: iconType,
  isDisabled: isDisabled,
  onClick: onClick,
  size: "s",
  color: "text",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 15
  }
})))), buttonType === 'text' && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
  "aria-label": ariaLabel,
  "data-test-subj": `${dataTestSubj}-button-menu-item`,
  disabled: isDisabled,
  onClick: onClick,
  color: "text",
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  "data-test-subj": `${dataTestSubj}-button`,
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 9
  }
}, content)), buttonType === 'emptyButton' && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: onClick,
  iconType: "timeline",
  flush: "right",
  size: "xs",
  "data-test-subj": dataTestSubj,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 7
  }
}, content));
ActionIconItemComponent.displayName = 'ActionIconItemComponent';
const ActionIconItem = exports.ActionIconItem = /*#__PURE__*/_react.default.memo(ActionIconItemComponent);