"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntervalAbbrScreenReader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/accessibility/interval_abbr_screen_reader/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IntervalAbbrScreenReader = ({
  interval
}) => {
  const screenReaderInterval = (0, _react.useMemo)(() => {
    if (interval) {
      const number = parseInt(interval.slice(0, -1), 10);
      const unit = interval.charAt(interval.length - 1);
      if (Number.isFinite(number)) {
        switch (unit) {
          case 's':
            {
              return i18n.SECONDS_SCREEN_READER(number);
            }
          case 'm':
            {
              return i18n.MINUTES_SCREEN_READER(number);
            }
          case 'h':
            {
              return i18n.HOURS_SCREEN_READER(number);
            }
        }
      }
    }
    return undefined;
  }, [interval]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "interval-abbr-value",
    "aria-hidden": Boolean(screenReaderInterval),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, interval), screenReaderInterval && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, screenReaderInterval)));
};
exports.IntervalAbbrScreenReader = IntervalAbbrScreenReader;