"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryActions = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _alerts_badge = require("./alerts_badge");
var _mini_attack_chain = require("./mini_attack_chain");
var _take_action = require("../../../take_action");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/panel_header/summary_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SummaryActionsComponent = ({
  attackDiscovery,
  replacements,
  setSelectedAttackDiscoveries
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const attackDiscoveries = (0, _react2.useMemo)(() => [attackDiscovery], [attackDiscovery]);
  const nonInteractive = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "summaryActions",
    gutterSize: "none",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-weight: ${euiTheme.font.weight.bold};
              margin-right: ${euiTheme.size.s};
            `,
    "data-test-subj": "attackChainLabel",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, i18n.ATTACK_CHAIN)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_mini_attack_chain.MiniAttackChain, {
    attackDiscovery: attackDiscovery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              color: ${euiTheme.colors.lightShade};
              margin-right: ${euiTheme.size.s};
            `,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, '|')), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-weight: ${euiTheme.font.weight.bold};
              margin-left: ${euiTheme.size.xs};
              margin-right: ${euiTheme.size.s};
            `,
    "data-test-subj": "alertsLabel",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, i18n.ALERTS)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_alerts_badge.AlertsBadge, {
    alertsCount: attackDiscovery.alertIds.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              color: ${euiTheme.colors.lightShade};
              margin-left: ${euiTheme.size.m};
              margin-right: ${euiTheme.size.s};
            `,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, '|'))), [attackDiscovery, euiTheme.colors.lightShade, euiTheme.font.weight.bold, euiTheme.size.m, euiTheme.size.s, euiTheme.size.xs]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "actions",
    gutterSize: "none",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, nonInteractive), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_take_action.TakeAction, {
    attackDiscoveries: attackDiscoveries,
    replacements: replacements,
    setSelectedAttackDiscoveries: setSelectedAttackDiscoveries,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  })));
};
SummaryActionsComponent.displayName = 'SummaryActions';
const SummaryActions = exports.SummaryActions = /*#__PURE__*/_react2.default.memo(SummaryActionsComponent);