"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldMarkdownRenderer = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_markdown_formatter/field_markdown_renderer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const contextId = 'FieldMarkdownRenderer';
const getFieldMarkdownRenderer = disableActions => {
  const FieldMarkdownRenderer = ({
    icon,
    name,
    value
  }) => {
    const {
      openRightPanel
    } = (0, _expandableFlyout.useExpandableFlyoutApi)();
    const {
      euiTheme
    } = (0, _eui.useEuiTheme)();
    const flyoutPanelProps = (0, _react2.useMemo)(() => (0, _helpers.getFlyoutPanelProps)({
      contextId,
      fieldName: name,
      value
    }), [name, value]);
    const onEntityClick = (0, _react2.useCallback)(() => {
      if (flyoutPanelProps != null) {
        openRightPanel(flyoutPanelProps);
      }
    }, [flyoutPanelProps, openRightPanel]);
    const entityButton = (0, _react2.useMemo)(() => flyoutPanelProps != null ? /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      css: (0, _react.css)`
              font-size: ${euiTheme.font.scale.s}rem;
            `,
      "data-test-subj": "entityButton",
      flush: "both",
      onClick: onEntityClick,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    }, value) : null, [euiTheme.font.scale.s, flyoutPanelProps, onEntityClick, value]);
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: name,
      "data-test-subj": "fieldMarkdownRendererToolTip",
      position: "top",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, disableActions ? /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": "disabledActionsBadge",
      iconType: icon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }, value) : /*#__PURE__*/_react2.default.createElement(_draggables.DraggableBadge, {
      contextId: "fieldMarkdownRenderer",
      eventId: "",
      iconType: icon,
      isAggregatable: false,
      field: name,
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, entityButton));
  };
  return FieldMarkdownRenderer;
};
exports.getFieldMarkdownRenderer = getFieldMarkdownRenderer;