"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingMessages = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react2 = _interopRequireWildcard(require("react"));
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _kibana = require("../../../../common/lib/kibana");
var _get_canceled_result_message = require("./get_canceled_result_message");
var _get_formatted_time = require("./get_formatted_time");
var _get_is_terminal_state = require("../get_is_terminal_state");
var _get_loading_callout_alerts_count = require("./get_loading_callout_alerts_count");
var _get_success_result_message = require("./get_success_result_message");
var i18n = _interopRequireWildcard(require("../translations"));
var _get_failure_result_message = require("./get_failure_result_message");
var _failure_accordion = require("./failure_accordion");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/loading_callout/loading_messages/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TEXT_COLOR = '#343741';
const LoadingMessagesComponent = ({
  alertsContextCount,
  connectorName,
  discoveries,
  end,
  generationEndTime,
  localStorageAttackDiscoveryMaxAlerts,
  loadingMessage,
  reason,
  start,
  status
}) => {
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const dateFormat = (0, _kibana.useDateFormat)();
  const formattedStart = (0, _react2.useMemo)(() => (0, _get_formatted_time.getFormattedDate)({
    date: start,
    dateFormat
  }), [start, dateFormat]);
  const formattedEnd = (0, _react2.useMemo)(() => (0, _get_formatted_time.getFormattedDate)({
    date: end,
    dateFormat
  }), [end, dateFormat]);
  const alertsCount = (0, _get_loading_callout_alerts_count.getLoadingCalloutAlertsCount)({
    alertsContextCount,
    defaultMaxAlerts: _elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS,
    localStorageAttackDiscoveryMaxAlerts
  });
  const isTerminalState = (0, _react2.useMemo)(() => (0, _get_is_terminal_state.getIsTerminalState)(status), [status]);
  const progressMessage = (0, _react2.useMemo)(() => connectorName != null ? i18n.ATTACK_DISCOVERY_GENERATION_IN_PROGRESS_VIA(connectorName) : i18n.ATTACK_DISCOVERY_GENERATION_IN_PROGRESS, [connectorName]);
  const resultMessage = (0, _react2.useMemo)(() => {
    if (status === 'succeeded') {
      return (0, _get_success_result_message.getSuccessResultMessage)({
        alertsContextCount,
        connectorName,
        dateFormat,
        discoveries,
        generationEndTime
      });
    }
    if (status === 'failed') {
      return (0, _get_failure_result_message.getFailureResultMessage)({
        connectorName,
        dateFormat,
        generationEndTime
      });
    }
    if (status === 'canceled') {
      return (0, _get_canceled_result_message.getCanceledResultMessage)({
        connectorName,
        dateFormat,
        generationEndTime
      });
    }

    // return default:
    return loadingMessage !== null && loadingMessage !== void 0 ? loadingMessage : (0, _elasticAssistantCommon.getAttackDiscoveryLoadingMessage)({
      alertsCount,
      end: formattedEnd,
      start: formattedStart
    });
  }, [alertsContextCount, alertsCount, connectorName, dateFormat, discoveries, formattedEnd, formattedStart, generationEndTime, loadingMessage, status]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "loadingMessages",
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, !isTerminalState && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: isDarkMode ? 'subdued' : TEXT_COLOR,
    css: (0, _react.css)`
              font-weight: 600;
            `,
    "data-test-subj": "attackDiscoveryGenerationInProgress",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, progressMessage)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: isDarkMode ? 'subdued' : TEXT_COLOR,
    css: (0, _react.css)`
            font-weight: 400;
          `,
    "data-test-subj": "aisCurrentlyAnalyzing",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, resultMessage)), status === 'failed' && reason != null && reason.length > 0 && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_failure_accordion.FailureAccordion, {
    failureReason: reason,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }))));
};
LoadingMessagesComponent.displayName = 'LoadingMessages';
const LoadingMessages = exports.LoadingMessages = /*#__PURE__*/_react2.default.memo(LoadingMessagesComponent);