"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _assistant_settings_management = require("@kbn/elastic-assistant/impl/assistant/settings/assistant_settings_management");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _i18n = require("@kbn/i18n");
var _translations = require("@kbn/elastic-assistant/impl/assistant/settings/translations");
var _const = require("@kbn/elastic-assistant/impl/assistant/settings/const");
var _use_space_aware_context = require("@kbn/elastic-assistant/impl/assistant/use_space_aware_context");
var _kibana = require("../../common/lib/kibana");
var _use_space_id = require("../../common/hooks/use_space_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/assistant/stack_management/management_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManagementSettings = exports.ManagementSettings = /*#__PURE__*/_react.default.memo(() => {
  const {
    application: {
      navigateToApp,
      capabilities: {
        securitySolutionAssistant: {
          'ai-assistant': securityAIAssistantEnabled
        }
      }
    },
    data: {
      dataViews
    },
    chrome: {
      docTitle,
      setBreadcrumbs
    },
    serverless
  } = (0, _kibana.useKibana)().services;
  const spaceId = (0, _use_space_id.useSpaceId)();
  docTitle.change(_translations.SECURITY_AI_SETTINGS);
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const currentTab = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = searchParams.get('tab')) !== null && _ref !== void 0 ? _ref : _const.CONVERSATIONS_TAB;
  }, [searchParams]);
  const handleTabChange = (0, _react.useCallback)(tab => {
    navigateToApp('management', {
      path: `ai/securityAiAssistantManagement?tab=${tab}`
    });
  }, [navigateToApp]);
  (0, _react.useEffect)(() => {
    if (serverless) {
      serverless.setBreadcrumbs([{
        text: _i18n.i18n.translate('xpack.securitySolution.assistant.settings.breadcrumb.serverless.security', {
          defaultMessage: 'AI Assistant'
        })
      }]);
    } else {
      setBreadcrumbs([{
        text: _i18n.i18n.translate('xpack.securitySolution.assistant.settings.breadcrumb.stackManagement', {
          defaultMessage: 'Stack Management'
        }),
        onClick: e => {
          e.preventDefault();
          navigateToApp('management');
        }
      }, {
        text: _i18n.i18n.translate('xpack.securitySolution.assistant.settings.breadcrumb.index', {
          defaultMessage: 'AI Assistants'
        }),
        onClick: e => {
          e.preventDefault();
          navigateToApp('management', {
            path: '/ai/aiAssistantManagementSelection'
          });
        }
      }, {
        text: _i18n.i18n.translate('xpack.securitySolution.assistant.settings.breadcrumb.security', {
          defaultMessage: 'Security'
        })
      }]);
    }
  }, [navigateToApp, serverless, setBreadcrumbs]);
  if (!securityAIAssistantEnabled) {
    navigateToApp('home');
  }
  return spaceId ? /*#__PURE__*/_react.default.createElement(_use_space_aware_context.AssistantSpaceIdProvider, {
    spaceId: spaceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_assistant_settings_management.AssistantSettingsManagement, {
    dataViews: dataViews,
    onTabChange: handleTabChange,
    currentTab: currentTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  })) : null;
});
ManagementSettings.displayName = 'ManagementSettings';