"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommentActionsPortal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactReversePortal = require("react-reverse-portal");
var _kibana = require("../../common/lib/kibana");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/assistant/comment_actions/comment_actions_portal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommentActionsPortal = () => {
  const {
    elasticAssistantSharedState
  } = (0, _kibana.useKibana)().services;
  const [portals, setPortals] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    const unmountActions = elasticAssistantSharedState.comments.registerActions({
      mount: args => target => {
        const portalId = args.message.timestamp + args.message.content;
        const portalNode = (0, _reactReversePortal.createHtmlPortalNode)();
        setPortals(prev => ({
          ...prev,
          [portalId]: {
            args,
            portalNode,
            target
          }
        }));
        return () => {
          portalNode.unmount();
          setPortals(prev => {
            const next = {
              ...prev
            };
            delete next[portalId];
            return next;
          });
        };
      }
    });
    return () => {
      unmountActions();
    };
  }, [elasticAssistantSharedState.comments]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.entries(portals).map(([portalId, {
    args,
    portalNode
  }]) => /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    key: portalId,
    node: portalNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_.CommentActions, {
    message: args.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }))), Object.entries(portals).map(([portalId, {
    portalNode,
    target
  }]) => target ? /*#__PURE__*/_reactDom.default.createPortal(/*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: portalNode,
    key: portalId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 35
    }
  }), target) : null));
};
exports.CommentActionsPortal = CommentActionsPortal;