"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetStarted = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _information_light = _interopRequireDefault(require("../../../common/images/information_light.png"));
var _asset_inventory_title = require("../asset_inventory_title");
var _centered_wrapper = require("./centered_wrapper");
var _hover_for_explanation_tooltip = require("./hover_for_explanation_tooltip");
var _empty_state_illustration_container = require("../empty_state_illustration_container");
var _use_enable_asset_inventory = require("./hooks/use_enable_asset_inventory");
var _constants = require("../../constants");
var _need_help = require("./need_help");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/onboarding/get_started.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GetStarted = () => {
  const {
    isEnabling,
    error,
    reset,
    enableAssetInventory
  } = (0, _use_enable_asset_inventory.useEnableAssetInventory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_asset_inventory_title.AssetInventoryTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_centered_wrapper.CenteredWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.errorTitle",
      defaultMessage: "Unable to show your Inventory",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 19
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.errorDescription",
      defaultMessage: "Something went wrong while setting things up. You can try again or go back to Get Started with Inventory.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "center",
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: enableAssetInventory,
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.error.tryAgain",
      defaultMessage: "Try again",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 25
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: reset,
      iconType: "arrowLeft",
      iconSide: "left",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.error.backToStart",
      defaultMessage: "Back to Get Started with Inventory",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 25
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _constants.TEST_SUBJ_ONBOARDING_GET_STARTED,
    icon: /*#__PURE__*/_react.default.createElement(_empty_state_illustration_container.EmptyStateIllustrationContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      url: _information_light.default,
      size: "fullWidth",
      alt: _i18n.i18n.translate('xpack.securitySolution.assetInventory.emptyState.illustrationAlt', {
        defaultMessage: 'No results'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 19
      }
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.getStarted.title",
      defaultMessage: "Get Started with Asset Inventory",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 19
      }
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description",
      defaultMessage: "Asset Inventory provides a unified view of all your organizations assets in one place. See everything detected by Elastic Security \u2014 whether from logs, {identity_providers}, {cloud_services}, {mdms} or configuration {databases} \u2014 all in a structured, searchable inventory. Enable Asset Inventory to gain complete visibility across your environment.",
      values: {
        identity_providers: /*#__PURE__*/_react.default.createElement(_hover_for_explanation_tooltip.HoverForExplanationTooltip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.identityProviders.helperText",
            defaultMessage: "Identity providers are services that store and manage user identities.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 115,
              columnNumber: 31
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.identityProviders",
          defaultMessage: "identity providers",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 29
          }
        })),
        cloud_services: /*#__PURE__*/_react.default.createElement(_hover_for_explanation_tooltip.HoverForExplanationTooltip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.cloudServices.helperText",
            defaultMessage: "Cloud services are services that provide cloud-based infrastructure, platforms, or software.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 130,
              columnNumber: 31
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.cloudServices",
          defaultMessage: "cloud services",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 29
          }
        })),
        mdms: /*#__PURE__*/_react.default.createElement(_hover_for_explanation_tooltip.HoverForExplanationTooltip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.mdms.helperText",
            defaultMessage: "Mobile Device Managers (MDMs) are services that manage mobile devices.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 145,
              columnNumber: 31
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 143,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, 'MDMs')),
        databases: /*#__PURE__*/_react.default.createElement(_hover_for_explanation_tooltip.HoverForExplanationTooltip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.databases.helperText",
            defaultMessage: "Databases are services that store and manage data.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 157,
              columnNumber: 31
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.databases",
          defaultMessage: "databases",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 163,
            columnNumber: 29
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 21
      }
    }))),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: enableAssetInventory,
      iconType: "plusInCircle",
      isLoading: isEnabling,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 17
      }
    }, isEnabling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.emptyState.enableAssetInventory.loading",
      defaultMessage: "Enabling Asset Inventory",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 21
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.emptyState.enableAssetInventory",
      defaultMessage: "Enable Asset Inventory",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 21
      }
    }))],
    footer: /*#__PURE__*/_react.default.createElement(_need_help.NeedHelp, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }))));
};
exports.GetStarted = GetStarted;