"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultNavigationTree = void 0;
var _security_launchpad_navigation_tree = require("./security_launchpad_navigation_tree");
var _dashboards_navigation_tree = require("./dashboards_navigation_tree");
var _rules_navigation_tree = require("./rules_navigation_tree");
var _cases_navigation_tree = require("./cases_navigation_tree");
var _investigations_navigation_tree = require("./investigations_navigation_tree");
var _explore_navigation_tree = require("./explore_navigation_tree");
var _assets_navigation_tree = require("./assets_navigation_tree");
var _entity_analytics_navigation_tree = require("./entity_analytics_navigation_tree");
var _ml_navigation_tree = require("./ml_navigation_tree");
var _v2_navigation_tree = require("./v2_navigation_tree");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultNavigationTree = exports.defaultNavigationTree = {
  dashboards: _dashboards_navigation_tree.createDashboardsNavigationTree,
  rules: _rules_navigation_tree.createRulesNavigationTree,
  cases: _cases_navigation_tree.createCasesNavigationTree,
  investigations: _investigations_navigation_tree.createInvestigationsNavigationTree,
  explore: _explore_navigation_tree.createExploreNavigationTree,
  launchpad: _security_launchpad_navigation_tree.createLaunchpadNavigationTree,
  assets: _assets_navigation_tree.createAssetsNavigationTree,
  entityAnalytics: _entity_analytics_navigation_tree.createEntityAnalyticsNavigationTree,
  ml: _ml_navigation_tree.createMachineLearningNavigationTree,
  // version 2 sidenav
  v2: _v2_navigation_tree.createV2NavigationTree
};