"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/spaces-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/space_aware_privilege_section/space_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const spaceToOption = (space, currentSelection) => {
  if (!space) {
    return;
  }
  return {
    id: `spaceOption_${space.id}`,
    label: space.name,
    color: (0, _public.getSpaceColor)(space),
    disabled: currentSelection === 'global' && space.id !== '*' || currentSelection === 'spaces' && space.id === '*'
  };
};
const spaceIdToOption = spaces => s => spaceToOption(spaces.find(space => space.id === s));
class SpaceSelector extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onChange", selectedSpaces => {
      this.props.onChange(selectedSpaces.map(s => s.id.split('spaceOption_')[1]));
    });
    (0, _defineProperty2.default)(this, "getOptions", () => {
      const options = this.props.spaces.map(space => spaceToOption(space, this.props.selectedSpaceIds.includes('*') ? 'global' : this.props.selectedSpaceIds.length > 0 ? 'spaces' : undefined));
      return options.filter(Boolean);
    });
    (0, _defineProperty2.default)(this, "getSelectedOptions", () => {
      const options = this.props.selectedSpaceIds.map(spaceIdToOption(this.props.spaces));
      return options.filter(Boolean);
    });
  }
  render() {
    const renderOption = (option, searchValue, contentClassName) => {
      const {
        color,
        label
      } = option;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: contentClassName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
        search: searchValue,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 13
        }
      }, label)));
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "data-test-subj": 'spaceSelectorComboBox',
      "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.spaceSelectorLabel', {
        defaultMessage: 'Spaces'
      }),
      placeholder: _i18n.i18n.translate('xpack.security.management.editRole.spaceSelectorPlaceholder', {
        defaultMessage: 'Add spaces...'
      }),
      fullWidth: true,
      options: this.getOptions(),
      renderOption: renderOption,
      selectedOptions: this.getSelectedOptions(),
      isDisabled: this.props.disabled,
      onChange: this.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    });
  }
}
exports.SpaceSelector = SpaceSelector;