"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleGroupEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _add_rule_button = require("./add_rule_button");
var _field_rule_editor = require("./field_rule_editor");
var _rule_group_title = require("./rule_group_title");
var _is_rule_group = require("../services/is_rule_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/rule_editor_panel/rule_group_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class RuleGroupEditor extends _react2.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "renderSubRules", () => {
      return this.props.rule.getRules().map((subRule, subRuleIndex, rules) => {
        const isLastRule = subRuleIndex === rules.length - 1;
        const divider = isLastRule ? null : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
          margin: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 11
          }
        }));
        if ((0, _is_rule_group.isRuleGroup)(subRule)) {
          return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
            key: subRuleIndex,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 104,
              columnNumber: 11
            }
          }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 105,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react2.default.createElement(RuleGroupEditor, {
            rule: subRule,
            parentRule: this.props.rule,
            allowAdd: this.props.allowAdd,
            ruleDepth: this.props.ruleDepth + 1,
            onChange: updatedSubRule => {
              const updatedRule = this.props.rule.clone();
              updatedRule.replaceRule(subRuleIndex, updatedSubRule);
              this.props.onChange(updatedRule);
            },
            onDelete: () => {
              const updatedRule = this.props.rule.clone();
              updatedRule.removeRule(subRuleIndex);
              this.props.onChange(updatedRule);
            },
            readOnly: this.props.readOnly,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 106,
              columnNumber: 15
            }
          })), divider);
        }
        return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
          key: subRuleIndex,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react2.default.createElement(_field_rule_editor.FieldRuleEditor, {
          rule: subRule,
          onChange: updatedSubRule => {
            const updatedRule = this.props.rule.clone();
            updatedRule.replaceRule(subRuleIndex, updatedSubRule);
            this.props.onChange(updatedRule);
          },
          onDelete: () => {
            const updatedRule = this.props.rule.clone();
            updatedRule.removeRule(subRuleIndex);
            this.props.onChange(updatedRule);
          },
          readOnly: this.props.readOnly,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 13
          }
        })), divider);
      });
    });
    (0, _defineProperty2.default)(this, "onAddRuleClick", newRule => {
      const updatedRule = this.props.rule.clone();
      updatedRule.addRule(newRule);
      this.props.onChange(updatedRule);
    });
  }
  render() {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      css: ({
        euiTheme
      }) => (0, _react.css)`
          background-color: ${this.props.ruleDepth % 2 ? euiTheme.colors.emptyShade : euiTheme.colors.lightestShade};
        `,
      hasBorder: true,
      hasShadow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_rule_group_title.RuleGroupTitle, {
      rule: this.props.rule,
      onChange: this.props.onChange,
      parentRule: this.props.parentRule,
      readOnly: this.props.readOnly,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 15
      }
    }, this.props.readOnly === false && /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      onClick: this.props.onDelete,
      size: "s",
      iconType: "trash",
      "data-test-subj": "deleteRuleGroupButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.deleteRuleGroupButton",
      defaultMessage: "Delete",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 21
      }
    }))))), this.renderSubRules(), this.props.allowAdd && this.props.readOnly === false && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_add_rule_button.AddRuleButton, {
      onClick: this.onAddRuleClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 17
      }
    })))));
  }
}
exports.RuleGroupEditor = RuleGroupEditor;
(0, _defineProperty2.default)(RuleGroupEditor, "defaultProps", {
  readOnly: false
});