"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingInfoPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _role_selector = require("../role_selector");
var _role_mapping_validation = require("../services/role_mapping_validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/mapping_info_panel/mapping_info_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class MappingInfoPanel extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getRoleMappingName", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 85,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingNameFormGroupTitle",
          defaultMessage: "Mapping name",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingNameFormGroupHelpText",
          defaultMessage: "A unique name used to identify this role mapping.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 11
          }
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingNameFormRowTitle",
          defaultMessage: "Name",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 13
          }
        }),
        fullWidth: true
      }, this.props.validateForm && (0, _role_mapping_validation.validateRoleMappingName)(this.props.roleMapping), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        name: 'name',
        value: this.props.roleMapping.name || '',
        onChange: this.onNameChange,
        "data-test-subj": 'roleMappingFormNameInput',
        disabled: this.props.mode === 'edit' || this.props.mode === 'view',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 11
        }
      })));
    });
    (0, _defineProperty2.default)(this, "getRolesOrRoleTemplatesSelector", () => {
      if (this.state.rolesMode === 'roles') {
        return this.getRolesSelector();
      }
      return this.getRoleTemplatesSelector();
    });
    (0, _defineProperty2.default)(this, "getRolesSelector", () => {
      const validationFunction = () => {
        if (!this.props.validateForm) {
          return {};
        }
        return (0, _role_mapping_validation.validateRoleMappingRoles)(this.props.roleMapping);
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRolesFormRowTitle",
          defaultMessage: "Roles",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("span", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRolesFormRowHelpText",
          defaultMessage: "Assign roles to your users.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 154,
            columnNumber: 13
          }
        }), this.getSwitchToRoleTemplateButton()),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        fullWidth: true
      }, validationFunction(), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_role_selector.RoleSelector, {
        "data-test-subj": 'roleMappingFormRoleSelector',
        rolesAPIClient: this.props.rolesAPIClient,
        roleMapping: this.props.roleMapping,
        mode: this.state.rolesMode,
        canUseInlineScripts: this.props.canUseInlineScripts,
        canUseStoredScripts: this.props.canUseStoredScripts,
        onChange: roleMapping => this.props.onChange(roleMapping),
        readOnly: this.props.mode === 'view',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 11
        }
      })));
    });
    (0, _defineProperty2.default)(this, "getSwitchToRoleTemplateButton", () => {
      if (this.props.mode !== 'view') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "switchToRoleTemplatesButton",
          onClick: () => {
            this.onRolesModeChange('templates');
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 179,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 185,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.switchToRoleTemplates",
          defaultMessage: "Switch to role templates",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 13
          }
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "inputOutput",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 190,
            columnNumber: 13
          }
        })));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "getRoleTemplatesSelector", () => {
      const validationFunction = () => {
        if (!this.props.validateForm) {
          return {};
        }
        return (0, _role_mapping_validation.validateRoleMappingRoleTemplates)(this.props.roleMapping);
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 208,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRoleTemplatesFormRowTitle",
          defaultMessage: "Role templates",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 209,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 216,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("span", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 217,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRoleTemplatesFormRowHelpText",
          defaultMessage: "Create templates that describe the roles to assign to your users.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 218,
            columnNumber: 15
          }
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: this.props.docLinks.links.apis.createRoleMappingTemplates,
          external: true,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 222,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingRoleTemplatesFormRowLearnMore",
          defaultMessage: "Learn about role templates",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 227,
            columnNumber: 17
          }
        }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 233,
            columnNumber: 13
          }
        }), this.getSwitchToRolesButton()),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        fullWidth: true
      }, validationFunction(), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_role_selector.RoleSelector, {
        "data-test-subj": 'roleMappingFormTemplateSelector',
        rolesAPIClient: this.props.rolesAPIClient,
        roleMapping: this.props.roleMapping,
        mode: this.state.rolesMode,
        canUseInlineScripts: this.props.canUseInlineScripts,
        canUseStoredScripts: this.props.canUseStoredScripts,
        onChange: roleMapping => this.props.onChange(roleMapping),
        readOnly: this.props.mode === 'view',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 11
        }
      })));
    });
    (0, _defineProperty2.default)(this, "getSwitchToRolesButton", () => {
      if (this.props.mode !== 'view') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => {
            this.onRolesModeChange('roles');
          },
          "data-test-subj": "switchToRolesButton",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 258,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 264,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.switchToRoles",
          defaultMessage: "Switch to roles",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 265,
            columnNumber: 13
          }
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "inputOutput",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 269,
            columnNumber: 13
          }
        })));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "getEnabledSwitch", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 281,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingEnabledFormRowTitle",
          defaultMessage: "Enable mapping",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 282,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingEnabledFormRowHelpText",
          defaultMessage: "Map roles to users based on their username, groups, and other metadata. When false, ignore mappings.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 289,
            columnNumber: 11
          }
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 279,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleMappingEnabledFormRowLabel",
          defaultMessage: "Enable mapping",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 298,
            columnNumber: 13
          }
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        name: 'enabled',
        label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.roleMappingEnabledLabel', {
          defaultMessage: 'Enable mapping'
        }),
        showLabel: false,
        "data-test-subj": "roleMappingsEnabledSwitch",
        checked: this.props.roleMapping.enabled,
        onChange: e => {
          this.props.onChange({
            ...this.props.roleMapping,
            enabled: e.target.checked
          });
        },
        disabled: this.props.mode === 'view',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 305,
          columnNumber: 11
        }
      })));
    });
    (0, _defineProperty2.default)(this, "onNameChange", e => {
      const name = e.target.value;
      this.props.onChange({
        ...this.props.roleMapping,
        name
      });
    });
    (0, _defineProperty2.default)(this, "onRolesModeChange", rolesMode => {
      const canUseTemplates = this.props.canUseInlineScripts || this.props.canUseStoredScripts;
      if (rolesMode === 'templates' && canUseTemplates) {
        // Create blank template as a starting point
        const defaultTemplate = this.props.canUseInlineScripts ? {
          template: {
            source: ''
          }
        } : {
          template: {
            id: ''
          }
        };
        this.props.onChange({
          ...this.props.roleMapping,
          roles: [],
          role_templates: [defaultTemplate]
        });
      }
      this.setState({
        rolesMode
      });
    });
    this.state = {
      rolesMode: props.roleMapping.role_templates && props.roleMapping.role_templates.length > 0 ? 'templates' : 'roles'
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.roleMappingTitle",
      defaultMessage: "Role mapping",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }), this.getRoleMappingName(), this.getEnabledSwitch(), this.getRolesOrRoleTemplatesSelector());
  }
}
exports.MappingInfoPanel = MappingInfoPanel;