"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRoleMappingPage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mapping_info_panel = require("./mapping_info_panel");
var _rule_editor_panel = require("./rule_editor_panel");
var _role_mapping_validation = require("./services/role_mapping_validation");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/edit_role_mapping_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class EditRoleMappingPage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getInfoPanelMode", () => {
      return this.isReadOnly() ? 'view' : this.editingExistingRoleMapping() ? 'edit' : 'create';
    });
    (0, _defineProperty2.default)(this, "getFormTitle", () => {
      if (this.isReadOnly()) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.readOnlyRoleMappingTitle",
          defaultMessage: "Viewing role mapping",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 202,
            columnNumber: 11
          }
        }), "\xA0", this.isReadOnlyRoleMapping() && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRoleMapping.readOnlyRoleMappingBadge.readOnlyRoleMappingCanNotBeModifiedTooltip",
            defaultMessage: "Read only role mappings are built-in and cannot be removed or modified.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 210,
              columnNumber: 17
            }
          }),
          "data-test-subj": "readOnlyRoleMappingTooltip",
          iconProps: {
            style: {
              verticalAlign: 'super'
            }
          },
          type: "lock",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 208,
            columnNumber: 13
          }
        }));
      }
      if (this.editingExistingRoleMapping()) {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.editRoleMappingTitle",
          defaultMessage: "Edit role mapping",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 227,
            columnNumber: 9
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.createRoleMappingTitle",
        defaultMessage: "Create role mapping",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "isObject", record => {
      return typeof record === 'object' && record !== null;
    });
    (0, _defineProperty2.default)(this, "isRoleMappingAnyRule", obj => {
      return this.isObject(obj) && 'any' in obj && Array.isArray(obj.any);
    });
    (0, _defineProperty2.default)(this, "isRoleMappingAllRule", obj => {
      return this.isObject(obj) && 'all' in obj && Array.isArray(obj.all);
    });
    (0, _defineProperty2.default)(this, "checkEmptyAnyAllMappings", obj => {
      const arrToCheck = [obj];
      while (arrToCheck.length > 0) {
        const currentObj = arrToCheck.pop();
        if (this.isObject(obj)) {
          for (const key in currentObj) {
            if (Object.hasOwn(currentObj, key)) {
              if (this.isRoleMappingAnyRule(currentObj)) {
                if (currentObj.any.length === 0) {
                  return true;
                }
                arrToCheck.push(...currentObj.any);
              } else if (this.isRoleMappingAllRule(currentObj)) {
                if (currentObj.all.length === 0) {
                  return true;
                }
                arrToCheck.push(...currentObj.all);
              } else if (this.isObject(currentObj[key])) {
                arrToCheck.push(currentObj[key]);
              }
            }
          }
        }
      }
      return false;
    });
    (0, _defineProperty2.default)(this, "getFormWarnings", () => {
      if (this.checkEmptyAnyAllMappings(this.state.roleMapping.rules)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: "Warning",
          color: "warning",
          iconType: "alert",
          "data-test-subj": "emptyAnyOrAllRulesWarning",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 284,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.emptyAnyAllMappingsWarning",
          defaultMessage: "Role mapping rules contains empty 'any' or 'all' rules. These empty rule groups will always evaluate to true. Please proceed with caution",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 290,
            columnNumber: 11
          }
        }));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "getFormButtons", () => {
      if (this.isReadOnly() === true) {
        return this.getReturnToRoleMappingListButton();
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 9
        }
      }, this.getSaveButton()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 308,
          columnNumber: 9
        }
      }, this.getCancelButton()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 309,
          columnNumber: 9
        }
      }), this.getDeleteButton());
    });
    (0, _defineProperty2.default)(this, "getReturnToRoleMappingListButton", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton
      // {...reactRouterNavigate(this.props.history, '')}
      , {
        onClick: this.backToRoleMappingsList,
        iconType: "arrowLeft",
        "data-test-subj": "roleMappingFormReturnButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 317,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.returnToRoleMappingListButton",
        defaultMessage: "Back to role mappings",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 323,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "getSaveButton", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        onClick: this.saveRoleMapping,
        isLoading: this.state.loadState === 'saveInProgress',
        disabled: !this.state.rulesValid || this.state.loadState === 'saveInProgress',
        "data-test-subj": "saveRoleMappingButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 333,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.saveRoleMappingButton",
        defaultMessage: "Save role mapping",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 340,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "getCancelButton", () => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.backToRoleMappingsList,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 350,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.cancelButton",
        defaultMessage: "Cancel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 351,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "getDeleteButton", () => {
      if (this.editingExistingRoleMapping() && !this.isReadOnly()) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 362,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_components.DeleteProvider, {
          roleMappingsAPI: this.props.roleMappingsAPI,
          notifications: this.props.notifications,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 363,
            columnNumber: 11
          }
        }, deleteRoleMappingsPrompt => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
            "data-test-subj": "deleteRoleMappingButton",
            onClick: () => deleteRoleMappingsPrompt([this.state.roleMapping], () => this.backToRoleMappingsList()),
            color: "danger",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 369,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRoleMapping.deleteRoleMappingButton",
            defaultMessage: "Delete role mapping",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 378,
              columnNumber: 19
            }
          }));
        }));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "onRuleValidityChange", rulesValid => {
      this.setState({
        rulesValid
      });
    });
    (0, _defineProperty2.default)(this, "saveRoleMapping", () => {
      if (!this.state.roleMapping) {
        return;
      }
      const {
        isInvalid
      } = (0, _role_mapping_validation.validateRoleMappingForSave)(this.state.roleMapping);
      if (isInvalid) {
        this.setState({
          validateForm: true
        });
        return;
      }
      const roleMappingName = this.state.roleMapping.name;
      this.setState({
        loadState: 'saveInProgress'
      });
      this.props.roleMappingsAPI.saveRoleMapping(this.state.roleMapping).then(() => {
        this.props.notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.security.management.editRoleMapping.saveSuccess', {
            defaultMessage: `Saved role mapping ''{roleMappingName}''`,
            values: {
              roleMappingName
            }
          }),
          'data-test-subj': 'savedRoleMappingSuccessToast'
        });
        this.backToRoleMappingsList();
      }).catch(e => {
        var _e$body;
        this.props.notifications.toasts.addError(e, {
          title: _i18n.i18n.translate('xpack.security.management.editRoleMapping.saveError', {
            defaultMessage: `Error saving role mapping`
          }),
          toastMessage: e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message
        });
        this.setState({
          loadState: 'saveInProgress'
        });
      });
    });
    (0, _defineProperty2.default)(this, "editingExistingRoleMapping", () => typeof this.props.name === 'string' && this.props.action === 'edit');
    (0, _defineProperty2.default)(this, "cloningExistingRoleMapping", () => typeof this.props.name === 'string' && this.props.action === 'clone');
    (0, _defineProperty2.default)(this, "isReadOnlyRoleMapping", () => {
      var _this$state$roleMappi, _this$state$roleMappi2;
      return (_this$state$roleMappi = this.state.roleMapping) === null || _this$state$roleMappi === void 0 ? void 0 : (_this$state$roleMappi2 = _this$state$roleMappi.metadata) === null || _this$state$roleMappi2 === void 0 ? void 0 : _this$state$roleMappi2._read_only;
    });
    (0, _defineProperty2.default)(this, "isReadOnly", () => this.props.readOnly || this.isReadOnlyRoleMapping());
    (0, _defineProperty2.default)(this, "backToRoleMappingsList", () => this.props.history.push('/'));
    this.state = {
      loadState: 'loading',
      roleMapping: null,
      hasCompatibleRealms: true,
      canUseStoredScripts: true,
      canUseInlineScripts: true,
      rulesValid: true,
      validateForm: false,
      formError: {
        isInvalid: false
      }
    };
  }
  componentDidMount() {
    this.loadAppData();
  }
  async componentDidUpdate(prevProps) {
    if (prevProps.name !== this.props.name) {
      await this.loadAppData();
    }
  }
  render() {
    const {
      loadState
    } = this.state;
    if (loadState === 'permissionDenied') {
      return /*#__PURE__*/_react.default.createElement(_components.PermissionDenied, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 14
        }
      });
    }
    if (loadState === 'loading') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        alignment: "center",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_components.SectionLoading, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: this.getFormTitle(),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.roleMappingDescription",
        defaultMessage: "Use role mappings to control which roles are assigned to your users. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: this.props.docLinks.links.security.mappingRoles,
            external: true,
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 131,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRoleMapping.learnMoreLinkText",
            defaultMessage: "Learn more about role mappings.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 136,
              columnNumber: 23
            }
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 15
        }
      }), !this.state.hasCompatibleRealms && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_components.NoCompatibleRealms, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 19
        }
      }))),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      isInvalid: this.state.formError.isInvalid,
      error: this.state.formError.error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_mapping_info_panel.MappingInfoPanel, {
      "data-test-subj": "roleMappingInfoPanel",
      roleMapping: this.state.roleMapping,
      onChange: roleMapping => this.setState({
        roleMapping
      }),
      mode: this.getInfoPanelMode(),
      validateForm: this.state.validateForm,
      canUseInlineScripts: this.state.canUseInlineScripts,
      canUseStoredScripts: this.state.canUseStoredScripts,
      rolesAPIClient: this.props.rolesAPIClient,
      docLinks: this.props.docLinks,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_rule_editor_panel.RuleEditorPanel, {
      "data-test-subj": "roleMappingRulePanel",
      rawRules: this.state.roleMapping.rules,
      validateForm: this.state.validateForm,
      onValidityChange: this.onRuleValidityChange,
      onChange: rules => this.setState({
        roleMapping: {
          ...this.state.roleMapping,
          rules
        }
      }),
      docLinks: this.props.docLinks,
      readOnly: this.isReadOnly(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }), this.getFormWarnings(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 11
      }
    }), this.getFormButtons()));
  }
  async loadAppData() {
    try {
      const [features, roleMapping] = await Promise.all([this.props.securityFeaturesAPI.checkFeatures(), this.editingExistingRoleMapping() || this.cloningExistingRoleMapping() ? this.props.roleMappingsAPI.getRoleMapping(this.props.name) : Promise.resolve({
        name: '',
        enabled: true,
        metadata: {},
        role_templates: [],
        roles: [],
        rules: {}
      })]);
      const {
        canReadSecurity,
        canUseStoredScripts,
        canUseInlineScripts,
        hasCompatibleRealms
      } = features;
      const loadState = canReadSecurity ? 'ready' : 'permissionDenied';
      this.setState({
        loadState,
        hasCompatibleRealms,
        canUseStoredScripts,
        canUseInlineScripts,
        roleMapping: {
          ...roleMapping,
          name: this.cloningExistingRoleMapping() ? '' : roleMapping.name
        }
      });
    } catch (e) {
      var _e$body$message, _e$body2;
      this.props.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.security.management.editRoleMapping.table.fetchingRoleMappingsErrorMessage', {
          defaultMessage: 'Error loading role mapping editor: {message}',
          values: {
            message: (_e$body$message = e === null || e === void 0 ? void 0 : (_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : _e$body2.message) !== null && _e$body$message !== void 0 ? _e$body$message : ''
          }
        }),
        'data-test-subj': 'errorLoadingRoleMappingEditorToast'
      });
      this.backToRoleMappingsList();
    }
  }
}
exports.EditRoleMappingPage = EditRoleMappingPage;
(0, _defineProperty2.default)(EditRoleMappingPage, "defaultProps", {
  readOnly: false
});