"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRulesetDetail = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _reactRouterDom = require("react-router-dom");
var _api_routes = require("../../../common/api_routes");
var _doc_links = require("../../../common/doc_links");
var _use_kibana = require("../../hooks/use_kibana");
var _use_put_query_rules_ruleset = require("../../hooks/use_put_query_rules_ruleset");
var _use_run_query_ruleset = require("../../hooks/use_run_query_ruleset");
var _query_rules_page_template = require("../../layout/query_rules_page_template");
var _query_rules_utils = require("../../utils/query_rules_utils");
var _error_prompt = require("../error_prompt/error_prompt");
var _delete_ruleset_modal = require("../query_rules_sets/delete_ruleset_modal");
var _query_rule_detail_panel = require("./query_rule_detail_panel");
var _use_query_ruleset_detail_state = require("./use_query_ruleset_detail_state");
var _use_fetch_ruleset_exists = require("../../hooks/use_fetch_ruleset_exists");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _use_query_rules_breadcrumbs = require("../../hooks/use_query_rules_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_ruleset_detail/query_ruleset_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryRulesetDetail = ({
  createMode = false
}) => {
  var _overlays$openConfirm, _queryRuleset$rules$l, _queryRuleset$rules, _tourStepsInfo$, _tourStepsInfo$$tourT, _queryRuleset$rules$l2, _queryRuleset$rules2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      application,
      http,
      history,
      overlays
    }
  } = (0, _use_kibana.useKibana)();
  const {
    rulesetId = ''
  } = (0, _reactRouterDom.useParams)();
  (0, _use_query_rules_breadcrumbs.useQueryRulesBreadcrumbs)(rulesetId);
  const {
    data: rulesetExists,
    isLoading: isFailsafeLoading
  } = (0, _use_fetch_ruleset_exists.useFetchQueryRulesetExist)(rulesetId);
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  (0, _react.useEffect)(() => {
    // This is a failsafe in case user navigates to an existing ruleset via URL directly
    if (createMode && rulesetExists) {
      application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/ruleset/${rulesetId}`));
    }
  }, [createMode, rulesetExists, application, http.basePath, rulesetId]);
  (0, _react.useEffect)(() => {
    var _useTracker$load;
    useTracker === null || useTracker === void 0 ? void 0 : (_useTracker$load = useTracker.load) === null || _useTracker$load === void 0 ? void 0 : _useTracker$load.call(useTracker, _constants.AnalyticsEvents.rulesetDetailPageLoaded);
  }, [useTracker]);
  const blockRender = createMode && rulesetExists || isFailsafeLoading;
  const {
    mutate: createRuleset
  } = (0, _use_put_query_rules_ruleset.usePutRuleset)(() => {
    if (createMode) {
      application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/ruleset/${rulesetId}`));
    }
  });
  const {
    queryRuleset,
    rules,
    unfilteredRules,
    setNewRules,
    addNewRule,
    deleteRule,
    updateRule,
    isInitialLoading,
    isError,
    error,
    setSearchFilter,
    searchFilter
  } = (0, _use_query_ruleset_detail_state.useQueryRulesetDetailState)({
    rulesetId,
    createMode
  });
  const [isPopoverActionsOpen, setPopoverActions] = (0, _react.useState)(false);
  const splitButtonPopoverActionsId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'splitButtonPopoverActionsId'
  });
  const TOUR_QUERY_RULES_STORAGE_KEY = 'queryRules.tour';
  const tourConfig = {
    currentTourStep: 1,
    isTourActive: true,
    tourPopoverWidth: 360
  };
  const tourStepsInfo = [{
    step: 1,
    title: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.tourStep1Title', {
      defaultMessage: 'Test your ruleset'
    }),
    content: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.tourStep1Content', {
      defaultMessage: 'Now you can try out the query rule results in the console'
    })
  }, {
    step: 2,
    title: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.tourStep2Title', {
      defaultMessage: 'Drag the rule to set the priority'
    }),
    content: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.tourStep2Content', {
      defaultMessage: 'Rules will trigger based on the priority order. The first rule will take precedence over any following rules'
    }),
    tourTargetRef: (0, _react.useRef)(null)
  }];
  const [tourState, setTourState] = (0, _react.useState)(() => {
    try {
      const initialState = localStorage.getItem(TOUR_QUERY_RULES_STORAGE_KEY);
      if (initialState) {
        try {
          return JSON.parse(initialState) || tourConfig;
        } catch (e) {
          return {
            ...tourConfig,
            isTourActive: false
          };
        }
      }
      return tourConfig;
    } catch (e) {
      return {
        ...tourConfig,
        isTourActive: false
      };
    }
  });
  (0, _react.useEffect)(() => {
    localStorage.setItem(TOUR_QUERY_RULES_STORAGE_KEY, JSON.stringify(tourState));
  }, [tourState]);
  const incrementStep = () => {
    setTourState({
      ...tourState,
      currentTourStep: tourState.currentTourStep + 1
    });
  };
  const descrementStep = () => {
    setTourState({
      ...tourState,
      currentTourStep: tourState.currentTourStep - 1
    });
  };
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    css: (0, _react2.css)`
        color: ${euiTheme.colors.danger};
      `,
    key: "delete",
    icon: "trash",
    disabled: createMode || isInitialLoading,
    onClick: () => setRulesetToDelete(rulesetId),
    "data-test-subj": "queryRulesetDetailDeleteButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.deleteRulesetButton', {
    defaultMessage: 'Delete ruleset'
  }))];
  const [rulesetToDelete, setRulesetToDelete] = (0, _react.useState)(null);
  const finishTour = () => {
    setTourState({
      ...tourState,
      isTourActive: false
    });
  };
  const handleSave = () => {
    setIsFormDirty(false);
    useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(createMode ? _constants.AnalyticsEvents.rulesetCreateClicked : _constants.AnalyticsEvents.rulesetUpdateClicked);
    createRuleset({
      rulesetId,
      forceWrite: true,
      rules
    });
  };
  const [isFormDirty, setIsFormDirty] = (0, _react.useState)(createMode);
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    cancelButtonText: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.unsavedPrompt.cancel', {
      defaultMessage: 'Continue setup'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.unsavedPrompt.confirm', {
      defaultMessage: 'Leave the page'
    }),
    hasUnsavedChanges: isFormDirty,
    history,
    http,
    messageText: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.unsavedPrompt.body', {
      defaultMessage: 'Make sure to save your changes before leaving this page.'
    }),
    navigateToUrl: application.navigateToUrl,
    openConfirm: (_overlays$openConfirm = overlays === null || overlays === void 0 ? void 0 : overlays.openConfirm) !== null && _overlays$openConfirm !== void 0 ? _overlays$openConfirm : () => Promise.resolve(false),
    titleText: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.unsavedPrompt.title', {
      defaultMessage: 'Your ruleset has some unsaved changes'
    })
  });
  return /*#__PURE__*/_react.default.createElement(_query_rules_page_template.QueryRulesPageTemplate, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 5
    }
  }, !isInitialLoading && !isError && !!queryRuleset && !blockRender && /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: rulesetId,
    breadcrumbs: [{
      text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "arrowLeft",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 19
        }
      }), ' ', _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.backButton', {
        defaultMessage: 'Back'
      })),
      'data-test-subj': 'queryRulesetDetailBackButton',
      color: 'primary',
      'aria-current': false,
      onClick: () => {
        useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.backToRulesetListClicked);
        application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}`));
      }
    }],
    restrictWidth: true,
    color: "primary",
    "data-test-subj": "queryRulesetDetailHeader",
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexEnd",
      key: "queryRulesetDetailHeaderButtons",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "queryRulesetDetailApiReferenceButton",
      iconType: "documentation",
      color: "text",
      "aria-label": _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.apiReferenceButton', {
        defaultMessage: 'API reference'
      }),
      href: _doc_links.docLinks.queryRulesApi,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.apiReferenceButton', {
      defaultMessage: 'API reference'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
      content: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 28
        }
      }, tourStepsInfo[0].content),
      isStepOpen: tourState.isTourActive && tourState.currentTourStep === 1,
      minWidth: tourState.tourPopoverWidth,
      onFinish: finishTour,
      step: 1,
      stepsTotal: ((_queryRuleset$rules$l = queryRuleset === null || queryRuleset === void 0 ? void 0 : (_queryRuleset$rules = queryRuleset.rules) === null || _queryRuleset$rules === void 0 ? void 0 : _queryRuleset$rules.length) !== null && _queryRuleset$rules$l !== void 0 ? _queryRuleset$rules$l : 0) > 1 ? 2 : 1,
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 295,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement("h6", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 23
        }
      }, tourStepsInfo[0].title)),
      anchorPosition: "rightUp",
      zIndex: 1,
      footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 302,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 303,
          columnNumber: 23
        }
      }, queryRuleset.rules.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "searchQueryRulesQueryRulesetDetailCloseTourButton",
        size: "s",
        color: "text",
        onClick: finishTour,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 305,
          columnNumber: 27
        }
      }, _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.closeTourButton', {
        defaultMessage: 'Close tour'
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "searchQueryRulesQueryRulesetDetailCloseTourButton",
        size: "s",
        color: "success",
        onClick: finishTour,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 316,
          columnNumber: 27
        }
      }, _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.closeTourButton', {
        defaultMessage: 'Close tour'
      }))), queryRuleset.rules.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "searchQueryRulesQueryRulesetDetailNextButton",
        color: "success",
        size: "s",
        onClick: incrementStep,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 330,
          columnNumber: 27
        }
      }, _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.nextTourButton', {
        defaultMessage: 'Next'
      })))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_use_run_query_ruleset.UseRunQueryRuleset, {
      disabled: createMode,
      rulesetId: rulesetId,
      type: "emptyButton",
      color: "text",
      content: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.testButton', {
        defaultMessage: 'Test in Console'
      }),
      onClick: () => {
        useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.testInConsoleClicked);
        finishTour();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 360,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "save",
      fill: true,
      color: "primary",
      "data-test-subj": "queryRulesetDetailHeaderSaveButton",
      onClick: handleSave,
      disabled: !isFormDirty || isInitialLoading || unfilteredRules.length === 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.queryRules.queryRulesetDetail.saveButton",
      defaultMessage: "Save",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 370,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: splitButtonPopoverActionsId,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        disabled: createMode || isInitialLoading || rules.length === 0,
        "data-test-subj": "searchQueryRulesQueryRulesetActionsButton",
        size: "m",
        iconType: "boxesVertical",
        "aria-label": "More",
        onClick: () => setPopoverActions(!isPopoverActionsOpen),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 380,
          columnNumber: 23
        }
      }),
      isOpen: isPopoverActionsOpen,
      closePopover: () => setPopoverActions(false),
      panelPaddingSize: "none",
      anchorPosition: "downLeft",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: items,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 21
      }
    })))))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }), !blockRender && !isFailsafeLoading && isError && createMode || !isError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_query_rule_detail_panel.QueryRuleDetailPanel, {
    rulesetId: rulesetId,
    setNewRules: setNewRules,
    addNewRule: addNewRule,
    deleteRule: deleteRule,
    updateRule: updateRule,
    rules: rules,
    unfilteredRules: unfilteredRules,
    tourInfo: tourStepsInfo[1],
    setIsFormDirty: setIsFormDirty,
    createMode: createMode,
    searchFilter: searchFilter,
    setSearchFilter: setSearchFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 13
    }
  }), ((_tourStepsInfo$ = tourStepsInfo[1]) === null || _tourStepsInfo$ === void 0 ? void 0 : (_tourStepsInfo$$tourT = _tourStepsInfo$.tourTargetRef) === null || _tourStepsInfo$$tourT === void 0 ? void 0 : _tourStepsInfo$$tourT.current) !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    anchor: () => {
      var _tourStepsInfo$2, _tourStepsInfo$2$tour;
      return ((_tourStepsInfo$2 = tourStepsInfo[1]) === null || _tourStepsInfo$2 === void 0 ? void 0 : (_tourStepsInfo$2$tour = _tourStepsInfo$2.tourTargetRef) === null || _tourStepsInfo$2$tour === void 0 ? void 0 : _tourStepsInfo$2$tour.current) || document.body;
    },
    content: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 423,
        columnNumber: 26
      }
    }, tourStepsInfo[1].content),
    isStepOpen: tourState.isTourActive && tourState.currentTourStep === 2,
    maxWidth: tourState.tourPopoverWidth,
    onFinish: finishTour,
    step: 1,
    stepsTotal: ((_queryRuleset$rules$l2 = queryRuleset === null || queryRuleset === void 0 ? void 0 : (_queryRuleset$rules2 = queryRuleset.rules) === null || _queryRuleset$rules2 === void 0 ? void 0 : _queryRuleset$rules2.length) !== null && _queryRuleset$rules$l2 !== void 0 ? _queryRuleset$rules$l2 : 0) > 1 ? 2 : 1,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 431,
        columnNumber: 21
      }
    }, tourStepsInfo[1].title)),
    anchorPosition: "downLeft",
    zIndex: 1,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 437,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 438,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "searchQueryRulesQueryRulesetDetailNextButton",
      size: "s",
      color: "text",
      onClick: descrementStep,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 439,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.backTourButton', {
      defaultMessage: 'Back'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "searchQueryRulesQueryRulesetDetailCloseTourButton",
      size: "s",
      color: "success",
      onClick: finishTour,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.closeTourButton', {
      defaultMessage: 'Close tour'
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 15
    }
  })), !blockRender && rulesetToDelete && /*#__PURE__*/_react.default.createElement(_delete_ruleset_modal.DeleteRulesetModal, {
    rulesetId: rulesetToDelete,
    closeDeleteModal: () => {
      setRulesetToDelete(null);
    },
    onSuccessAction: () => {
      application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}`));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 9
    }
  }), !blockRender && isError && !createMode && error && /*#__PURE__*/_react.default.createElement(_error_prompt.ErrorPrompt, {
    errorType: (0, _query_rules_utils.isPermissionError)(error) ? 'missingPermissions' : (0, _query_rules_utils.isNotFoundError)(error) ? 'notFound' : 'generic',
    "data-test-subj": "queryRulesetDetailErrorPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 480,
      columnNumber: 9
    }
  }));
};
exports.QueryRulesetDetail = QueryRulesetDetail;