"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateRulesetModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _query_rules_utils = require("../../utils/query_rules_utils");
var _use_kibana = require("../../hooks/use_kibana");
var _use_fetch_ruleset_exists = require("../../hooks/use_fetch_ruleset_exists");
var _api_routes = require("../../../common/api_routes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/overview/create_ruleset_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateRulesetModal = ({
  onClose
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'createRulesetModalTitle'
  });
  const formId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'createRulesetModalForm'
  });
  const [name, setName] = (0, _react.useState)('');
  const [rawName, setRawName] = (0, _react.useState)('');
  const [conflictError, setConflictError] = (0, _react.useState)(false);
  const [checkName, setCheckName] = (0, _react.useState)('');
  const {
    data: rulesetExist
  } = (0, _use_fetch_ruleset_exists.useFetchQueryRulesetExist)(checkName, () => {
    application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/ruleset/${name}/create`));
  }, () => {
    setConflictError(true);
  });
  const {
    services: {
      http,
      application
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    "data-test-subj": "searchRulesetCreateRulesetModalHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.createRulesetModal.title",
    defaultMessage: "Create ruleset",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: formId,
    component: "form",
    onSubmit: e => {
      e.preventDefault();
      setCheckName(name);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.queryRules.createRulesetModal.nameLabel', {
      defaultMessage: 'Ruleset Name'
    }),
    helpText: !!rawName && !conflictError ? _i18n.i18n.translate('xpack.queryRules.createRulesetModal.nameHelpText', {
      defaultMessage: 'Your ruleset set will be named: {name}',
      values: {
        name
      }
    }) : undefined,
    isInvalid: conflictError,
    error: conflictError ? _i18n.i18n.translate('xpack.queryRules.createRulesetModal.nameErrorText', {
      defaultMessage: 'A ruleset with id {name} already exists.',
      values: {
        name
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: conflictError,
    "data-test-subj": "searchRulesetCreateRulesetModalFieldText",
    value: rawName,
    onChange: e => {
      setRawName(e.target.value);
      setName((0, _query_rules_utils.formatRulesetName)(e.target.value));
      setConflictError(false);
      setCheckName('');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })), conflictError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.createRulesetModal.editInsteadText",
    defaultMessage: "Choose a different name or edit the existing ruleset.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.createRulesetModal.forceWriteText",
    defaultMessage: "Edit ruleset: ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchRulesetCreateRulesetModalEditLink",
    onClick: () => {
      application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/ruleset/${name}`));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  }, name))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchRulesetCreateRulesetModalCancelButton",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.createRulesetModal.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchRulesetCreateRulesetModalCreateButton",
    form: formId,
    fill: true,
    disabled: !name || !!checkName && rulesetExist,
    type: "submit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.createRulesetModal.createButton",
    defaultMessage: "Create ruleset",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }))));
};
exports.CreateRulesetModal = CreateRulesetModal;