"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstructionsField = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/summarization_panel/instructions_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InstructionsField = ({
  value,
  onChange
}) => {
  const [baseValue, setBaseValue] = _react.default.useState(value);
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const handlePromptChange = e => {
    onChange(e.target.value);
  };
  const handleFocus = () => {
    setBaseValue(value);
  };
  const handleBlur = () => {
    if (baseValue !== value) {
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.instructionsFieldChanged);
    }
    setBaseValue('');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.searchPlayground.sidebar.instructionsField.label', {
      defaultMessage: 'Instructions'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "question",
      color: "subdued",
      content: _i18n.i18n.translate('xpack.searchPlayground.sidebar.instructionsField.help', {
        defaultMessage: 'These preliminary instructions and guidelines define the behavior of the model. Be clear and specific for best results.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    })),
    fullWidth: true,
    isInvalid: (0, _lodash.isEmpty)(value),
    error: (0, _lodash.isEmpty)(value) ? _i18n.i18n.translate('xpack.searchPlayground.sidebar.instructionsField.errorMessage', {
      defaultMessage: 'Instructions cannot be empty'
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "instructionsPrompt",
    placeholder: _i18n.i18n.translate('xpack.searchPlayground.sidebar.instructionsField.placeholder', {
      defaultMessage: 'Replace me'
    }),
    value: value,
    onFocus: handleFocus,
    onBlur: handleBlur,
    onChange: handlePromptChange,
    fullWidth: true,
    isInvalid: (0, _lodash.isEmpty)(value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
exports.InstructionsField = InstructionsField;