"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceEndpoints = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_inference_endpoints = require("../hooks/use_inference_endpoints");
var _tabular_page = require("./all_inference_endpoints/tabular_page");
var _inference_endpoints_header = require("./inference_endpoints_header");
var _add_inference_flyout_wrapper = require("./add_inference_endpoints/add_inference_flyout_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/inference_endpoints.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InferenceEndpoints = () => {
  const {
    data,
    refetch
  } = (0, _use_inference_endpoints.useQueryInferenceEndpoints)();
  const [isAddInferenceFlyoutOpen, setIsAddInferenceFlyoutOpen] = (0, _react.useState)(false);
  const onFlyoutOpen = (0, _react.useCallback)(() => {
    setIsAddInferenceFlyoutOpen(true);
  }, []);
  const onFlyoutClose = (0, _react.useCallback)(() => {
    setIsAddInferenceFlyoutOpen(false);
  }, []);
  const reload = (0, _react.useCallback)(() => {
    refetch();
  }, [refetch]);
  const inferenceEndpoints = data || [];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inference_endpoints_header.InferenceEndpointsHeader, {
    onFlyoutOpen: onFlyoutOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    className: "eui-yScroll",
    "data-test-subj": "inferenceManagementPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_tabular_page.TabularPage, {
    inferenceEndpoints: inferenceEndpoints,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  })), isAddInferenceFlyoutOpen && /*#__PURE__*/_react.default.createElement(_add_inference_flyout_wrapper.AddInferenceFlyoutWrapper, {
    onFlyoutClose: onFlyoutClose,
    reloadFn: reload,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }));
};
exports.InferenceEndpoints = InferenceEndpoints;