"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulIndexStorageStat = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _quick_stat = require("./quick_stat");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/quick_stats/stateful_storage_stat.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatefulIndexStorageStat = ({
  index,
  open,
  setOpen
}) => {
  var _index$size, _index$size2, _index$primary_size;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_quick_stat.QuickStat, {
    open: open,
    setOpen: setOpen,
    icon: "storage",
    iconColor: euiTheme.colors.fullShade,
    title: _i18n.i18n.translate('xpack.searchIndices.quickStats.storage_heading', {
      defaultMessage: 'Storage'
    }),
    "data-test-subj": "QuickStatsStorage",
    secondaryTitle: (_index$size = index.size) !== null && _index$size !== void 0 ? _index$size : '0b',
    stats: [{
      title: _constants.INDEX_SIZE_LABEL,
      description: (_index$size2 = index.size) !== null && _index$size2 !== void 0 ? _index$size2 : '0b'
    }, {
      title: _i18n.i18n.translate('xpack.searchIndices.quickStats.primarySize_title', {
        defaultMessage: 'Primary Size'
      }),
      description: (_index$primary_size = index.primary_size) !== null && _index$primary_size !== void 0 ? _index$primary_size : '0b'
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  });
};
exports.StatefulIndexStorageStat = StatefulIndexStorageStat;