"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _results_fields = require("./results_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/kbn-search-index-documents/components/result/editable_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditableResult = ({
  leftSideItem,
  hasIndexSelector,
  onIndexSelectorChange,
  onIdSelectorChange,
  onDeleteDocument,
  onExpand,
  indices = [],
  fields = [],
  initialDocId = '',
  initialIndex = '',
  error,
  isLoading = false
}) => {
  const [isExpanded, setIsExpanded] = _react.default.useState(false);
  const [documentId, setDocumentId] = _react.default.useState(initialDocId);
  const [index, setIndex] = _react.default.useState(initialIndex);
  const selectIndexPlaceholder = _i18n.i18n.translate('xpack.sharedKbnSearchIndexDocuments.editableResult.selectIndexPlaceholder', {
    defaultMessage: 'Select index'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s",
    color: "plain",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, leftSideItem && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 28
    }
  }, leftSideItem), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "editableResultDocumentId",
    value: documentId,
    onChange: e => setDocumentId(e.target.value),
    onBlur: e => {
      if (onIdSelectorChange) {
        onIdSelectorChange(e.target.value);
      }
    },
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.sharedKbnSearchIndexDocuments.editableResult.documentIdPlaceholder', {
      defaultMessage: 'Document ID'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  })), hasIndexSelector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "editableResultIndexSelector",
    placeholder: selectIndexPlaceholder,
    "aria-label": selectIndexPlaceholder,
    singleSelection: {
      asPlainText: true
    },
    options: indices.map(i => ({
      label: i,
      value: 'index'
    })),
    isClearable: false,
    selectedOptions: index ? [{
      label: index,
      value: 'index'
    }] : [],
    onChange: selected => {
      var _selected$;
      const selectedIndex = ((_selected$ = selected[0]) === null || _selected$ === void 0 ? void 0 : _selected$.label) || '';
      setIndex(selectedIndex);
      if (onIndexSelectorChange) {
        (0, _lodash.debounce)(() => {
          onIndexSelectorChange(selectedIndex);
        }, 300)();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, error && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 27
    }
  }), !error && hasIndexSelector && (isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: isExpanded ? 'fold' : 'unfold',
    color: "primary",
    "aria-label": isExpanded ? _i18n.i18n.translate('xpack.sharedKbnSearchIndexDocuments.editableResult.collapseFieldsButtonAriaLabel', {
      defaultMessage: 'Collapse fields'
    }) : _i18n.i18n.translate('xpack.sharedKbnSearchIndexDocuments.editableResult.expandFieldsButtonAriaLabel', {
      defaultMessage: 'Expand fields'
    }),
    onClick: () => {
      if (onExpand && !isExpanded) {
        onExpand();
      }
      setIsExpanded(!isExpanded);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    onClick: onDeleteDocument,
    "aria-label": _i18n.i18n.translate('xpack.sharedKbnSearchIndexDocuments.editableResult.deleteDocumentButtonAriaLabel', {
      defaultMessage: 'Delete document'
    }),
    "data-test-subj": "editableResultDeleteButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  })))))), !error && (fields === null || fields === void 0 ? void 0 : fields.length) > 0 && isExpanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s",
    color: "plain",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_results_fields.ResultFields, {
    documentId: "12345",
    isExpanded: false,
    fields: fields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }))), error && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  }), "\xA0", error)))));
};
exports.EditableResult = EditableResult;