"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuntimeFieldEditorLoader = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("./shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/runtime_fields/public/load_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getRuntimeFieldEditorLoader = coreSetup => async () => {
  const {
    RuntimeFieldEditorFlyoutContent
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components')));
  const [core] = await coreSetup.getStartServices();
  const {
    uiSettings,
    theme,
    overlays,
    docLinks,
    settings
  } = core;
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    uiSettings,
    settings,
    theme
  });
  let overlayRef = null;
  const openEditor = ({
    onSave,
    defaultValue,
    ctx
  }) => {
    const closeEditor = () => {
      if (overlayRef) {
        overlayRef.close();
        overlayRef = null;
      }
    };
    const onSaveField = field => {
      closeEditor();
      onSave(field);
    };
    overlayRef = overlays.openFlyout((0, _shared_imports.toMountPoint)(/*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(RuntimeFieldEditorFlyoutContent, {
      onSave: onSaveField,
      onCancel: () => {
        var _overlayRef;
        return (_overlayRef = overlayRef) === null || _overlayRef === void 0 ? void 0 : _overlayRef.close();
      },
      docLinks: docLinks,
      defaultValue: defaultValue,
      ctx: ctx,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 13
      }
    })), core));
    return closeEditor;
  };
  return {
    openEditor
  };
};
exports.getRuntimeFieldEditorLoader = getRuntimeFieldEditorLoader;