"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateDateHistogramInterval = validateDateHistogramInterval;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps_config/validate_date_histogram_interval.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  InvalidEsIntervalFormatError,
  InvalidEsCalendarIntervalError,
  parseEsInterval
} = _public.search.aggs;
function validateDateHistogramInterval(dateHistogramInterval) {
  if (!dateHistogramInterval || !dateHistogramInterval.trim()) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.dateHistogramIntervalMissing",
      defaultMessage: "Interval is required.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 17,
        columnNumber: 7
      }
    })];
  }
  try {
    parseEsInterval(dateHistogramInterval);
  } catch (error) {
    if (error instanceof InvalidEsIntervalFormatError) {
      return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.errors.dateHistogramIntervalInvalidFormat",
        defaultMessage: "Invalid interval format.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 9
        }
      })];
    }
    if (error instanceof InvalidEsCalendarIntervalError) {
      const {
        unit
      } = error;
      return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.errors.dateHistogramIntervalInvalidCalendarInterval",
        defaultMessage: "The ''{unit}'' unit only allows values of 1. Try {suggestion}.",
        values: {
          unit,
          suggestion: /*#__PURE__*/_react.default.createElement("strong", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 45,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.errors.dateHistogramIntervalInvalidCalendarIntervalSuggestion",
            defaultMessage: "1{unit}",
            values: {
              unit
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 46,
              columnNumber: 17
            }
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 9
        }
      })];
    }
    throw error;
  }
  return undefined;
}