"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepHistogram = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation_links = require("../../../services/documentation_links");
var _components = require("../../components");
var _components2 = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps/step_histogram.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class StepHistogram extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onSelectField", field => {
      const {
        fields: {
          histogram
        },
        onFieldsChange
      } = this.props;
      onFieldsChange({
        histogram: histogram.concat(field)
      });
    });
    (0, _defineProperty2.default)(this, "onRemoveField", field => {
      const {
        fields: {
          histogram
        },
        onFieldsChange
      } = this.props;
      onFieldsChange({
        histogram: histogram.filter(histogramField => histogramField !== field)
      });
    });
    (0, _defineProperty2.default)(this, "renderErrors", () => {
      const {
        areStepErrorsVisible,
        hasErrors
      } = this.props;
      if (!areStepErrorsVisible || !hasErrors) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_components2.StepError, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 12
        }
      });
    });
  }
  render() {
    const {
      fields,
      histogramFields
    } = this.props;
    const {
      histogram
    } = fields;
    const columns = [{
      field: 'name',
      name: 'Field',
      sortable: true
    }];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateHistogramTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepHistogramTitle",
      defaultMessage: "Histogram (optional)",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepHistogram.histogramDescription",
      defaultMessage: "Select the fields you want to bucket using numeric intervals.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_components2.JobWizardStepAction, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: _documentation_links.documentationLinks.apis.createRollupJobsRequest,
      target: "_blank",
      iconType: "question",
      "data-test-subj": "rollupJobCreateHistogramDocsButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepHistogram.readDocsButtonLabel",
      defaultMessage: "Histogram docs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.FieldList, {
      columns: columns,
      fields: histogram,
      onRemoveField: this.onRemoveField,
      emptyMessage: /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 25
        }
      }, "No histogram fields added"),
      addButton: /*#__PURE__*/_react.default.createElement(_components2.FieldChooser, {
        buttonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.create.stepHistogram.fieldsChooserLabel",
          defaultMessage: "Add histogram fields",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 123,
            columnNumber: 17
          }
        }),
        columns: columns,
        fields: histogramFields,
        selectedFields: histogram,
        onSelectField: this.onSelectField,
        dataTestSubj: "rollupJobHistogramFieldChooser",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 13
        }
      }),
      dataTestSubj: "rollupJobHistogramFieldList",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }), this.renderInterval(), this.renderErrors());
  }
  renderInterval() {
    const {
      fields,
      onFieldsChange,
      areStepErrorsVisible,
      fieldErrors
    } = this.props;
    const {
      histogram,
      histogramInterval
    } = fields;
    const {
      histogramInterval: errorHistogramInterval
    } = fieldErrors;
    if (!histogram.length) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepHistogram.sectionHistogramIntervalTitle",
        defaultMessage: "Histogram interval",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 17
        }
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepHistogram.sectionHistogramIntervalDescription",
        defaultMessage: "This is the interval of histogram buckets to be generated when rolling up, e.g. 5 will create buckets that are five units wide (0-5, 5-10, etc). Note that only one interval can be specified in the histogram group, meaning that all fields being grouped via the histogram must share the same interval.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 13
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepHistogram.fieldHistogramIntervalLabel",
        defaultMessage: "Interval",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 15
        }
      }),
      error: errorHistogramInterval,
      isInvalid: Boolean(areStepErrorsVisible && errorHistogramInterval),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: !histogramInterval && histogramInterval !== 0 ? '' : Number(histogramInterval),
      onChange: e => onFieldsChange({
        histogramInterval: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorHistogramInterval),
      fullWidth: true,
      "data-test-subj": "rollupJobCreateHistogramInterval",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    }))));
  }
}
exports.StepHistogram = StepHistogram;
(0, _defineProperty2.default)(StepHistogram, "propTypes", {
  fields: _propTypes.default.object.isRequired,
  onFieldsChange: _propTypes.default.func.isRequired,
  fieldErrors: _propTypes.default.object.isRequired,
  hasErrors: _propTypes.default.bool.isRequired,
  areStepErrorsVisible: _propTypes.default.bool.isRequired,
  histogramFields: _propTypes.default.array.isRequired
});