"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobActionMenuUi = exports.JobActionMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _confirm_delete_modal = require("./confirm_delete_modal");
var _services = require("../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/components/job_action_menu/job_action_menu.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class JobActionMenuUi extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "closeDeleteConfirmationModal", () => {
      this.setState({
        showDeleteConfirmation: false
      });
    });
    (0, _defineProperty2.default)(this, "openDeleteConfirmationModal", () => {
      this.setState({
        showDeleteConfirmation: true
      });
    });
    (0, _defineProperty2.default)(this, "confirmDeleteModal", () => {
      const {
        showDeleteConfirmation
      } = this.state;
      if (!showDeleteConfirmation) {
        return null;
      }
      const {
        deleteJobs,
        jobs
      } = this.props;
      const onConfirmDelete = () => {
        this.closePopover();
        deleteJobs();
      };
      const isSingleSelection = this.isSingleSelection();
      return /*#__PURE__*/_react.default.createElement(_confirm_delete_modal.ConfirmDeleteModal, {
        isSingleSelection: isSingleSelection,
        jobs: jobs,
        onConfirm: onConfirmDelete,
        onCancel: this.closeDeleteConfirmationModal,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "isSingleSelection", () => {
      return this.props.jobs.length === 1;
    });
    this.state = {
      isPopoverOpen: false,
      showDeleteConfirmation: false
    };
  }
  panels() {
    const {
      startJobs,
      stopJobs,
      cloneJob
    } = this.props;
    const isSingleSelection = this.isSingleSelection() ? 1 : 0;
    const items = [];
    if (this.canStartJobs()) {
      items.push({
        name: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.startJobLabel', {
          defaultMessage: 'Start {isSingleSelection, plural, one {job} other {jobs}}',
          values: {
            isSingleSelection
          }
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "play",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 15
          }
        }),
        onClick: () => {
          this.closePopover();
          startJobs();
        }
      });
    }
    if (this.canStopJobs()) {
      items.push({
        name: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.stopJobLabel', {
          defaultMessage: 'Stop {isSingleSelection, plural, one {job} other {jobs}}',
          values: {
            isSingleSelection
          }
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "stop",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 84,
            columnNumber: 15
          }
        }),
        onClick: () => {
          this.closePopover();
          stopJobs();
        }
      });
    }
    if (this.canCloneJob()) {
      items.push({
        name: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.cloneJobLabel', {
          defaultMessage: 'Clone job'
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          "data-test-subj": "jobCloneActionContextMenu",
          type: "copy",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 15
          }
        }),
        onClick: () => {
          this.closePopover();
          const {
            jobs
          } = this.props;
          cloneJob(jobs[0]);
        }
      });
    }
    if (this.canDeleteJobs()) {
      items.push({
        name: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJobLabel', {
          defaultMessage: 'Delete {isSingleSelection, plural, one {job} other {jobs}}',
          values: {
            isSingleSelection
          }
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "trash",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 15
          }
        }),
        onClick: () => {
          this.closePopover();
          this.openDeleteConfirmationModal();
        }
      });
    }
    const panelTree = {
      id: 0,
      title: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.panelTitle', {
        defaultMessage: 'Job options'
      }),
      items
    };
    return (0, _services.flattenPanelTree)(panelTree);
  }
  canStartJobs() {
    const {
      jobs
    } = this.props;
    return jobs.some(job => job.status === 'stopped');
  }
  canStopJobs() {
    const {
      jobs
    } = this.props;
    return jobs.some(job => job.status === 'started');
  }
  canCloneJob() {
    const {
      jobs
    } = this.props;
    return Boolean(jobs && jobs.length === 1);
  }
  canDeleteJobs() {
    const {
      jobs
    } = this.props;
    const areAllJobsStopped = jobs.findIndex(job => job.status === 'started') === -1;
    return areAllJobsStopped;
  }
  render() {
    const {
      isUpdating
    } = this.props;
    if (isUpdating) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        gutterSize: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobActionMenu.updatingText",
        defaultMessage: "Updating",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 15
        }
      }))));
    }
    const jobCount = this.props.jobs.length;
    const {
      iconSide,
      anchorPosition,
      iconType,
      label = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.buttonLabel', {
        defaultMessage: 'Manage {jobCount, plural, one {job} other {jobs}}',
        values: {
          jobCount
        }
      })
    } = this.props;
    const panels = this.panels();
    const actionsAriaLabel = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.jobActionMenuButtonAriaLabel', {
      defaultMessage: 'Job options'
    });
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "jobActionMenuButton",
      iconSide: iconSide,
      "aria-label": actionsAriaLabel,
      onClick: this.onButtonClick,
      iconType: iconType,
      fill: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 7
      }
    }, label);
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 7
      }
    }, this.confirmDeleteModal(), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: anchorPosition,
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      "data-test-subj": "jobActionContextMenu",
      initialPanelId: 0,
      panels: panels,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 11
      }
    })));
  }
}
exports.JobActionMenuUi = JobActionMenuUi;
(0, _defineProperty2.default)(JobActionMenuUi, "propTypes", {
  startJobs: _propTypes.default.func.isRequired,
  stopJobs: _propTypes.default.func.isRequired,
  deleteJobs: _propTypes.default.func.isRequired,
  cloneJob: _propTypes.default.func.isRequired,
  isUpdating: _propTypes.default.bool.isRequired,
  iconSide: _propTypes.default.string,
  anchorPosition: _propTypes.default.string,
  label: _propTypes.default.node,
  iconType: _propTypes.default.string,
  jobs: _propTypes.default.array
});
(0, _defineProperty2.default)(JobActionMenuUi, "defaultProps", {
  iconSide: 'right',
  anchorPosition: 'rightUp',
  iconType: 'arrowDown',
  jobs: []
});
const JobActionMenu = exports.JobActionMenu = JobActionMenuUi;