"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ReportSchedulesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _queryString = require("query-string");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingPublic = require("@kbn/reporting-public");
var _utils = require("../utils");
var _use_get_scheduled_list = require("../hooks/use_get_scheduled_list");
var _job_utils = require("../../../common/job_utils");
var _report_schedule_indicator = require("./report_schedule_indicator");
var _use_bulk_disable = require("../hooks/use_bulk_disable");
var _translations = require("../../translations");
var _scheduled_report_flyout = require("./scheduled_report_flyout");
var _truncated_title = require("./truncated_title");
var _disable_report_confirmation_modal = require("./disable_report_confirmation_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/report_schedules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReportSchedulesTable = props => {
  var _scheduledList$total;
  const {
    apiClient
  } = props;
  const {
    http
  } = (0, _reportingPublic.useKibana)().services;
  const [selectedReport, setSelectedReport] = (0, _react.useState)(null);
  const [isConfigFlyOutOpen, setIsConfigFlyOutOpen] = (0, _react.useState)(false);
  const [isDisableModalConfirmationOpen, setIsDisableModalConfirmationOpen] = (0, _react.useState)(false);
  const [queryParams, setQueryParams] = (0, _react.useState)({
    page: 1,
    perPage: 50
  });
  const {
    data: scheduledList,
    isLoading
  } = (0, _use_get_scheduled_list.useGetScheduledList)({
    ...queryParams
  });
  const {
    mutateAsync: bulkDisableScheduledReports
  } = (0, _use_bulk_disable.useBulkDisable)();
  const sortedList = (0, _lodash.orderBy)((scheduledList === null || scheduledList === void 0 ? void 0 : scheduledList.data) || [], ['created_at'], ['desc']);
  const tableColumns = [{
    field: 'payload.objectType',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.typeTitle', {
      defaultMessage: 'Type'
    }),
    width: '5%',
    render: objectType => /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      "data-test-subj": "reportObjectType",
      type: (0, _utils.guessAppIconTypeFromObjectType)(objectType),
      size: "s",
      content: (0, _utils.getDisplayNameFromObjectType)(objectType),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    })
  }, {
    field: 'title',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.reportTitle', {
      defaultMessage: 'Title'
    }),
    width: '22%',
    render: (title, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": `reportTitle`,
      onClick: () => {
        setReportAndOpenConfigFlyout(item);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_truncated_title.TruncatedTitle, {
      text: title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 11
      }
    })),
    mobileOptions: {
      header: false,
      width: '100%'
    }
  }, {
    field: 'status',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.statusTitle', {
      defaultMessage: 'Status'
    }),
    width: '10%',
    render: (_status, item) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: item.enabled ? 'primary' : 'subdued',
        "data-test-subj": `reportStatus-${item.enabled ? 'active' : 'disabled'}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }, item.enabled ? _i18n.i18n.translate('xpack.reporting.schedules.status.active', {
        defaultMessage: 'Active'
      }) : _i18n.i18n.translate('xpack.reporting.schedules.status.disabled', {
        defaultMessage: 'Disabled'
      }));
    }
  }, {
    field: 'schedule',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.scheduleTitle', {
      defaultMessage: 'Schedule'
    }),
    width: '10%',
    render: schedule => /*#__PURE__*/_react.default.createElement(_report_schedule_indicator.ReportScheduleIndicator, {
      schedule: schedule,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    })
  }, {
    field: 'next_run',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.nextScheduleTitle', {
      defaultMessage: 'Next schedule'
    }),
    width: '20%',
    render: (nextRun, item) => {
      return item.enabled ? (0, _moment.default)(nextRun).format('YYYY-MM-DD @ hh:mm A') : '—';
    }
  }, {
    field: 'jobtype',
    width: '10%',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.fileType', {
      defaultMessage: 'File Type'
    }),
    render: jobtype => (0, _job_utils.prettyPrintJobType)(jobtype),
    mobileOptions: {
      show: false
    }
  }, {
    field: 'created_by',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.createdByTitle', {
      defaultMessage: 'Created by'
    }),
    width: '15%',
    render: createdBy => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "baseline",
        "data-test-subj": "reportCreatedBy",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: createdBy,
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        className: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 15
        }
      }, createdBy)));
    }
  }, {
    field: 'actions',
    name: _i18n.i18n.translate('xpack.reporting.schedules.tableColumns.actionsTitle', {
      defaultMessage: 'Actions'
    }),
    width: '8%',
    actions: [{
      name: _i18n.i18n.translate('xpack.reporting.schedules.table.viewConfig.title', {
        defaultMessage: 'View schedule config'
      }),
      description: _i18n.i18n.translate('xpack.reporting.schedules.table.viewConfig.description', {
        defaultMessage: 'View schedule configuration details'
      }),
      'data-test-subj': item => `reportViewConfig-${item.id}`,
      type: 'icon',
      icon: 'calendar',
      onClick: item => setReportAndOpenConfigFlyout(item)
    }, {
      name: item => {
        var _item$payload, _item$payload2;
        return _i18n.i18n.translate('xpack.reporting.schedules.table.openDashboard.title', {
          defaultMessage: 'Open in {objectType}',
          values: {
            objectType: (_item$payload = item.payload) !== null && _item$payload !== void 0 && _item$payload.objectType ? (0, _utils.getDisplayNameFromObjectType)((_item$payload2 = item.payload) === null || _item$payload2 === void 0 ? void 0 : _item$payload2.objectType) : 'Kibana'
          }
        });
      },
      description: item => _i18n.i18n.translate('xpack.reporting.schedules.table.openDashboard.description', {
        defaultMessage: 'Open the Kibana app where this report was generated.'
      }),
      'data-test-subj': item => `reportOpenDashboard-${item.id}`,
      type: 'icon',
      icon: 'dashboardApp',
      available: item => {
        var _item$payload3;
        return Boolean((_item$payload3 = item.payload) === null || _item$payload3 === void 0 ? void 0 : _item$payload3.locatorParams);
      },
      onClick: async item => {
        var _item$payload4;
        const searchParams = (0, _queryString.stringify)({
          scheduledReportId: item.id,
          ...queryParams
        });
        const path = (0, _reportingCommon.buildKibanaPath)({
          basePath: http.basePath.serverBasePath,
          spaceId: (_item$payload4 = item.payload) === null || _item$payload4 === void 0 ? void 0 : _item$payload4.spaceId,
          appPath: _reportingCommon.REPORTING_REDIRECT_APP
        });
        const href = `${path}?${searchParams}`;
        window.open(href, '_blank');
        window.focus();
      }
    }, {
      name: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.title', {
        defaultMessage: 'Disable schedule'
      }),
      description: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.description', {
        defaultMessage: 'Disable report schedule'
      }),
      'data-test-subj': item => `reportDisableSchedule-${item.id}`,
      enabled: item => item.enabled,
      type: 'icon',
      icon: 'cross',
      onClick: item => setReportAndOpenDisableModal(item)
    }]
  }];
  const setReportAndOpenConfigFlyout = (0, _react.useCallback)(report => {
    setSelectedReport(report);
    setIsConfigFlyOutOpen(true);
  }, [setSelectedReport, setIsConfigFlyOutOpen]);
  const unSetReportAndCloseConfigFlyout = (0, _react.useCallback)(() => {
    setSelectedReport(null);
    setIsConfigFlyOutOpen(false);
  }, [setSelectedReport, setIsConfigFlyOutOpen]);
  const setReportAndOpenDisableModal = (0, _react.useCallback)(report => {
    setSelectedReport(report);
    setIsDisableModalConfirmationOpen(true);
  }, [setSelectedReport, setIsDisableModalConfirmationOpen]);
  const unSetReportAndCloseDisableModal = (0, _react.useCallback)(() => {
    setSelectedReport(null);
    setIsDisableModalConfirmationOpen(false);
  }, [setSelectedReport, setIsDisableModalConfirmationOpen]);
  const onConfirm = (0, _react.useCallback)(() => {
    if (selectedReport) {
      bulkDisableScheduledReports({
        ids: [selectedReport.id]
      });
    }
    unSetReportAndCloseDisableModal();
  }, [selectedReport, bulkDisableScheduledReports, unSetReportAndCloseDisableModal]);
  const onCancel = (0, _react.useCallback)(() => unSetReportAndCloseDisableModal(), [unSetReportAndCloseDisableModal]);
  const tableOnChangeCallback = (0, _react.useCallback)(criteria => {
    const {
      index: page,
      size: perPage
    } = criteria.page;
    setQueryParams(prev => ({
      ...prev,
      page: page + 1,
      perPage
    }));
  }, [setQueryParams]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "reportSchedulesTable",
    items: sortedList,
    columns: tableColumns,
    loading: isLoading,
    pagination: {
      pageIndex: queryParams.page - 1,
      pageSize: queryParams.perPage,
      totalItemCount: (_scheduledList$total = scheduledList === null || scheduledList === void 0 ? void 0 : scheduledList.total) !== null && _scheduledList$total !== void 0 ? _scheduledList$total : 0
    },
    noItemsMessage: _translations.NO_CREATED_REPORTS_DESCRIPTION,
    onChange: tableOnChangeCallback,
    rowProps: () => ({
      'data-test-subj': 'scheduledReportRow'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 7
    }
  }), selectedReport && isConfigFlyOutOpen && /*#__PURE__*/_react.default.createElement(_scheduled_report_flyout.ScheduledReportFlyout, {
    apiClient: apiClient,
    onClose: () => {
      unSetReportAndCloseConfigFlyout();
    },
    scheduledReport: (0, _utils.transformScheduledReport)(selectedReport),
    availableReportTypes: [{
      id: selectedReport.jobtype,
      label: (0, _job_utils.prettyPrintJobType)(selectedReport.jobtype)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 9
    }
  }), selectedReport && isDisableModalConfirmationOpen ? /*#__PURE__*/_react.default.createElement(_disable_report_confirmation_modal.DisableReportConfirmationModal, {
    title: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.modalTitle', {
      defaultMessage: 'Disable schedule'
    }),
    message: _i18n.i18n.translate('xpack.reporting.schedules.table.disableSchedule.modalMessage', {
      defaultMessage: 'Disabling this schedule will stop the generation of future exports. You will not be able to enable this schedule again.'
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 9
    }
  }) : null);
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ReportSchedulesTable = ReportSchedulesTable;