"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCloudRemoteAddress = exports.isCloudAdvancedOptionsEnabled = exports.i18nTexts = exports.convertCloudRemoteAddressToProxyConnection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lib = require("../../../../../../../common/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/components/remote_cluster_config_steps/remote_cluster_form/validators/validate_cloud_url.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = exports.i18nTexts = {
  urlEmpty: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.cloudDeploymentForm.remoteAddressRequiredError",
    defaultMessage: "A remote address is required.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  }),
  urlInvalid: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.cloudDeploymentForm.remoteAddressInvalidError",
    defaultMessage: "Remote address is invalid.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  })
};
const CLOUD_DEFAULT_PROXY_PORT = '9400';
const EMPTY_PROXY_VALUES = {
  proxyAddress: '',
  serverName: ''
};
const PROTOCOL_REGEX = new RegExp(/^https?:\/\//);
const DEFAULT_SOCKET_CONNECTIONS = 18;
const isCloudAdvancedOptionsEnabled = cluster => {
  var _extractHostAndPort;
  // The toggle is switched off by default
  if (!cluster) {
    return false;
  }
  const {
    proxyAddress,
    serverName,
    proxySocketConnections
  } = cluster;
  if (!proxyAddress) {
    return false;
  }
  const {
    host
  } = (_extractHostAndPort = (0, _lib.extractHostAndPort)(proxyAddress)) !== null && _extractHostAndPort !== void 0 ? _extractHostAndPort : {};
  return host !== serverName || proxySocketConnections != null && proxySocketConnections !== DEFAULT_SOCKET_CONNECTIONS;
};
exports.isCloudAdvancedOptionsEnabled = isCloudAdvancedOptionsEnabled;
const formatUrl = url => {
  var _url;
  url = ((_url = url) !== null && _url !== void 0 ? _url : '').trim().toLowerCase();
  // delete http(s):// protocol string if any
  url = url.replace(PROTOCOL_REGEX, '');
  return url;
};
const convertCloudRemoteAddressToProxyConnection = url => {
  var _extractHostAndPort2;
  url = formatUrl(url);
  if (!url || !(0, _lib.isAddressValid)(url)) {
    return EMPTY_PROXY_VALUES;
  }
  const {
    host,
    port
  } = (_extractHostAndPort2 = (0, _lib.extractHostAndPort)(url)) !== null && _extractHostAndPort2 !== void 0 ? _extractHostAndPort2 : {};
  const proxyAddress = port ? url : `${host}:${CLOUD_DEFAULT_PROXY_PORT}`;
  return {
    proxyAddress,
    serverName: host
  };
};
exports.convertCloudRemoteAddressToProxyConnection = convertCloudRemoteAddressToProxyConnection;
const validateCloudRemoteAddress = url => {
  if (!url) {
    return i18nTexts.urlEmpty;
  }
  url = formatUrl(url);
  if (!(0, _lib.isAddressValid)(url)) {
    return i18nTexts.urlInvalid;
  }
  return null;
};
exports.validateCloudRemoteAddress = validateCloudRemoteAddress;