"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingHeaderActionMenu = ProfilingHeaderActionMenu;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _queryString = _interopRequireDefault(require("query-string"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url = _interopRequireDefault(require("url"));
var _use_profiling_router = require("../hooks/use_profiling_router");
var _add_data_view = require("../views/add_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/profiling_header_action_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ProfilingHeaderActionMenu() {
  const router = (0, _use_profiling_router.useProfilingRouter)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.profiling.header.storageExplorerLink.tooltip', {
      defaultMessage: 'This module is not GA. Please help us by reporting any bugs.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    onClick: () => {
      const query = _queryString.default.parse(window.location.search);
      const storageExplorerURL = _url.default.format({
        pathname: '/storage-explorer',
        query: {
          kuery: query.kuery,
          rangeFrom: query.rangeFrom || 'now-15m',
          rangeTo: query.rangeTo || 'now'
        }
      });
      history.push(storageExplorerURL);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.profiling.headerActionMenu.storageExplorer', {
    defaultMessage: 'Storage explorer'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    href: router.link('/settings'),
    color: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.profiling.headerActionMenu.settings', {
    defaultMessage: 'Settings'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    href: router.link('/add-data-instructions', {
      query: {
        selectedTab: _add_data_view.AddDataTabs.Kubernetes
      }
    }),
    color: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.profiling.headerActionMenu.addData', {
    defaultMessage: 'Add data'
  })));
}