"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _i18n = require("@kbn/i18n");
var _profilingUtils = require("@kbn/profiling-utils");
var _react = _interopRequireDefault(require("react"));
var _cpu_label_with_hint = require("../cpu_label_with_hint");
var _label_with_hint = require("../label_with_hint");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/differential_topn_functions_grid/get_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getColumns = compareFrameAction => [{
  id: _profilingUtils.TopNFunctionSortField.Rank,
  actions: {
    showHide: false
  },
  displayAsText: 'Rank',
  initialWidth: 65,
  schema: 'numeric'
}, {
  id: _profilingUtils.TopNFunctionSortField.Frame,
  actions: {
    showHide: false
  },
  displayAsText: _i18n.i18n.translate('xpack.profiling.functionsView.functionColumnLabel', {
    defaultMessage: 'Function'
  }),
  cellActions: [compareFrameAction]
}, {
  id: _profilingUtils.TopNFunctionSortField.Samples,
  initialWidth: 120,
  schema: 'numeric',
  actions: {
    showHide: false
  },
  display: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
    label: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel', {
      defaultMessage: 'Samples'
    }),
    hint: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel.hint', {
      defaultMessage: 'Estimated values'
    }),
    labelSize: "s",
    labelStyle: {
      fontWeight: 700
    },
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  })
}, {
  id: _profilingUtils.TopNFunctionSortField.SelfCPU,
  actions: {
    showHide: false
  },
  schema: 'numeric',
  initialWidth: 120,
  display: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
    type: "self",
    labelSize: "s",
    labelStyle: {
      fontWeight: 700
    },
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  })
}, {
  id: _profilingUtils.TopNFunctionSortField.TotalCPU,
  actions: {
    showHide: false
  },
  schema: 'numeric',
  initialWidth: 120,
  display: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
    type: "total",
    labelSize: "s",
    labelStyle: {
      fontWeight: 700
    },
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  })
}, {
  id: _profilingUtils.TopNComparisonFunctionSortField.ComparisonRank,
  actions: {
    showHide: false
  },
  schema: 'numeric',
  displayAsText: 'Rank',
  initialWidth: 69,
  displayHeaderCellProps: {
    className: 'thickBorderLeft'
  }
}, {
  id: _profilingUtils.TopNComparisonFunctionSortField.ComparisonFrame,
  actions: {
    showHide: false
  },
  displayAsText: _i18n.i18n.translate('xpack.profiling.functionsView.functionColumnLabel', {
    defaultMessage: 'Function'
  }),
  cellActions: [compareFrameAction]
}, {
  id: _profilingUtils.TopNComparisonFunctionSortField.ComparisonSamples,
  actions: {
    showHide: false
  },
  schema: 'numeric',
  initialWidth: 120,
  display: /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
    label: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel', {
      defaultMessage: 'Samples'
    }),
    hint: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel.hint', {
      defaultMessage: 'Estimated values'
    }),
    labelSize: "s",
    labelStyle: {
      fontWeight: 700
    },
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  })
}, {
  id: _profilingUtils.TopNComparisonFunctionSortField.ComparisonSelfCPU,
  actions: {
    showHide: false
  },
  schema: 'numeric',
  initialWidth: 120,
  display: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
    type: "self",
    labelSize: "s",
    labelStyle: {
      fontWeight: 700
    },
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  })
}, {
  id: _profilingUtils.TopNComparisonFunctionSortField.ComparisonTotalCPU,
  actions: {
    showHide: false
  },
  schema: 'numeric',
  initialWidth: 120,
  display: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
    type: "total",
    labelSize: "s",
    labelStyle: {
      fontWeight: 700
    },
    iconSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  })
}, {
  displayAsText: 'Diff',
  actions: {
    showHide: false
  },
  id: _profilingUtils.TopNComparisonFunctionSortField.ComparisonDiff,
  initialWidth: 70,
  isSortable: false
}];
exports.getColumns = getColumns;