"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.productInterceptRegistrationConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/product_intercept/public/intercept_registration_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * @description Returns the registration configuration for the product intercept.
 * This configuration defines the steps and content of the intercept
 * that prompts users for feedback on their experience with the product.
 */
const productInterceptRegistrationConfig = ({
  eventReporter,
  surveyUrl,
  productOffering
}) => {
  return {
    steps: [{
      id: 'start',
      title: _i18n.i18n.translate('productIntercept.prompter.step.start.title', {
        defaultMessage: 'Help us improve {productOffering}',
        values: {
          productOffering
        }
      }),
      content: () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        key: "productInterceptPrompterStartContent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "productIntercept.prompter.step.start.content",
        defaultMessage: "We are always looking for ways to improve {productOffering}. Please take a moment to share your feedback with us.",
        values: {
          productOffering
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 13
        }
      }))
    }, {
      id: 'satisfaction',
      title: _i18n.i18n.translate('productIntercept.prompter.step.satisfaction.title', {
        defaultMessage: 'Overall, how satisfied or dissatisfied are you with {productOffering}?',
        values: {
          productOffering
        }
      }),
      content: ({
        onValue
      }) => {
        return /*#__PURE__*/_react.default.createElement(_components.NPSScoreInput, {
          lowerBoundHelpText: _i18n.i18n.translate('productIntercept.prompter.step.satisfaction.lowerBoundDescriptionText', {
            defaultMessage: 'Very dissatisfied'
          }),
          upperBoundHelpText: _i18n.i18n.translate('productIntercept.prompter.step.satisfaction.upperBoundDescriptionText', {
            defaultMessage: 'Very satisfied'
          }),
          onChange: onValue,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 13
          }
        });
      }
    }, {
      id: 'ease',
      title: _i18n.i18n.translate('productIntercept.prompter.step.ease.title', {
        defaultMessage: 'Overall, how difficult or easy is it to use {productOffering}?',
        values: {
          productOffering
        }
      }),
      content: ({
        onValue
      }) => {
        return /*#__PURE__*/_react.default.createElement(_components.NPSScoreInput, {
          lowerBoundHelpText: _i18n.i18n.translate('productIntercept.prompter.step.ease.lowerBoundDescriptionText', {
            defaultMessage: 'Very difficult'
          }),
          upperBoundHelpText: _i18n.i18n.translate('productIntercept.prompter.step.ease.upperBoundDescriptionText', {
            defaultMessage: 'Very easy'
          }),
          onChange: onValue,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 13
          }
        });
      }
    }, {
      id: 'completion',
      title: _i18n.i18n.translate('productIntercept.prompter.step.completion.title', {
        defaultMessage: 'Thanks for the feedback!'
      }),
      content: () => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          key: "productInterceptPrompterCompletionContent",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "productIntercept.prompter.step.completion.content",
          defaultMessage: "If you'd like to participate in future research to help improve {productOffering}, <link>click here</link>.",
          values: {
            productOffering,
            link: chunks => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              external: true,
              target: "_blank",
              href: surveyUrl.toString(),
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 122,
                columnNumber: 21
              }
            }, chunks)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 15
          }
        }));
      }
    }],
    onProgress: ({
      stepId,
      stepResponse,
      runId
    }) => {
      eventReporter.reportInterceptInteractionProgress({
        interceptRunId: runId,
        metricId: stepId,
        value: Number(stepResponse)
      });
    },
    onFinish: ({
      response: feedbackResponse,
      runId
    }) => {
      eventReporter.reportInterceptInteractionTermination({
        interactionType: 'completion',
        interceptRunId: runId
      });
    },
    onDismiss: ({
      runId
    }) => {
      // still update user profile run count, a dismissal is still an interaction
      eventReporter.reportInterceptInteractionTermination({
        interactionType: 'dismissal',
        interceptRunId: runId
      });
    }
  };
};
exports.productInterceptRegistrationConfig = productInterceptRegistrationConfig;