"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _panelLoader = require("@kbn/panel-loader");
var _std = require("@kbn/std");
var _react = _interopRequireDefault(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../kibana_services");
var _use_panel_error_css = require("./use_panel_error_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/presentation_panel/public/panel_component/presentation_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const errorLoadingPanel = _i18n.i18n.translate('presentationPanel.error.errorWhenLoadingPanel', {
  defaultMessage: 'An error occurred while loading this panel.'
});
const PresentationPanel = props => {
  var _passThroughProps$com;
  const panelErrorCss = (0, _use_panel_error_css.usePanelErrorCss)();
  const {
    Component,
    hidePanelChrome,
    ...passThroughProps
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    loading,
    value
  } = (0, _useAsync.default)(async () => {
    var _results$2$value, _results$2$value2;
    if (hidePanelChrome) {
      return {
        unwrappedComponent: (0, _std.isPromise)(Component) ? await Component : Component
      };
    }
    const startServicesPromise = (0, _kibana_services.untilPluginStartServicesReady)();
    const componentPromise = (0, _std.isPromise)(Component) ? Component : Promise.resolve(Component);
    const results = await Promise.allSettled([startServicesPromise, componentPromise, Promise.resolve().then(() => _interopRequireWildcard(require('./panel_module')))]);
    let loadErrorReason;
    for (const result of results) {
      if (result.status === 'rejected') {
        loadErrorReason = result.reason;
        break;
      }
    }
    return {
      loadErrorReason,
      Panel: results[2].status === 'fulfilled' ? (_results$2$value = results[2].value) === null || _results$2$value === void 0 ? void 0 : _results$2$value.PresentationPanelInternal : undefined,
      PanelError: results[2].status === 'fulfilled' ? (_results$2$value2 = results[2].value) === null || _results$2$value2 === void 0 ? void 0 : _results$2$value2.PresentationPanelErrorInternal : undefined,
      unwrappedComponent: results[1].status === 'fulfilled' ? results[1].value : undefined
    };

    // Ancestry chain is expected to use 'key' attribute to reset DOM and state
    // when unwrappedComponent needs to be re-loaded
  }, []);
  if (loading) return props.hideLoader ? null : /*#__PURE__*/_react.default.createElement(_panelLoader.PanelLoader, {
    showShadow: props.showShadow,
    showBorder: props.showBorder,
    css: (0, _react2.css)`
          border-radius: ${euiTheme.border.radius.medium};
        `,
    dataTestSubj: "embed dablePanelLoadingIndicator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  });
  const Panel = value === null || value === void 0 ? void 0 : value.Panel;
  const PanelError = value === null || value === void 0 ? void 0 : value.PanelError;
  const UnwrappedComponent = value === null || value === void 0 ? void 0 : value.unwrappedComponent;
  const shouldHavePanel = !hidePanelChrome;
  if (value !== null && value !== void 0 && value.loadErrorReason || shouldHavePanel && !Panel || !UnwrappedComponent) {
    var _value$loadErrorReaso, _value$loadErrorReaso2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      css: panelErrorCss,
      className: "eui-fullHeight",
      "data-test-subj": "embeddableError",
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, PanelError ? /*#__PURE__*/_react.default.createElement(PanelError, {
      error: new Error((_value$loadErrorReaso = value === null || value === void 0 ? void 0 : value.loadErrorReason) !== null && _value$loadErrorReaso !== void 0 ? _value$loadErrorReaso : errorLoadingPanel),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }) : (_value$loadErrorReaso2 = value === null || value === void 0 ? void 0 : value.loadErrorReason) !== null && _value$loadErrorReaso2 !== void 0 ? _value$loadErrorReaso2 : errorLoadingPanel);
  }
  return shouldHavePanel && Panel ? /*#__PURE__*/_react.default.createElement(Panel, (0, _extends2.default)({
    Component: UnwrappedComponent
  }, passThroughProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(UnwrappedComponent, (0, _extends2.default)({}, (_passThroughProps$com = passThroughProps.componentProps) !== null && _passThroughProps$com !== void 0 ? _passThroughProps$com : {}, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  })));
};
exports.PresentationPanel = PresentationPanel;