"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OsqueryActionResults = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@kbn/react-query");
var _empty_prompt = require("../../routes/components/empty_prompt");
var _kibana = require("../../common/lib/kibana");
var _query_client = require("../../query_client");
var _shared_imports = require("../../shared_imports");
var _osquery_result = require("./osquery_result");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/shared_components/osquery_results/osquery_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OsqueryActionResultsComponent = ({
  ruleName,
  actionItems,
  ecsData
}) => {
  const {
    read
  } = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  return !read ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'osquery-results',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, actionItems === null || actionItems === void 0 ? void 0 : actionItems.map(item => {
    var _item$fields, _item$fields$action_i, _item$fields2, _item$fields2$queries, _item$fields3;
    const actionId = (_item$fields = item.fields) === null || _item$fields === void 0 ? void 0 : (_item$fields$action_i = _item$fields.action_id) === null || _item$fields$action_i === void 0 ? void 0 : _item$fields$action_i[0];
    const queryId = (_item$fields2 = item.fields) === null || _item$fields2 === void 0 ? void 0 : (_item$fields2$queries = _item$fields2['queries.action_id']) === null || _item$fields2$queries === void 0 ? void 0 : _item$fields2$queries[0];
    const startDate = (_item$fields3 = item.fields) === null || _item$fields3 === void 0 ? void 0 : _item$fields3['@timestamp'][0];
    return /*#__PURE__*/_react.default.createElement(_osquery_result.OsqueryResult, {
      key: actionId,
      actionId: actionId,
      queryId: queryId,
      startDate: startDate,
      ruleName: ruleName,
      ecsData: ecsData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 11
      }
    });
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
};
const OsqueryActionResults = exports.OsqueryActionResults = /*#__PURE__*/_react.default.memo(OsqueryActionResultsComponent);
const OsqueryActionResultsWrapperComponent = ({
  services,
  ...restProps
}) => /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, (0, _extends2.default)({}, services, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 3
  }
}), /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
  services: services,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
  client: _query_client.queryClient,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(OsqueryActionResults, (0, _extends2.default)({}, restProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 9
  }
})))));
const OsqueryActionResultsWrapper = exports.default = /*#__PURE__*/_react.default.memo(OsqueryActionResultsWrapperComponent);

// eslint-disable-next-line import/no-default-export